/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect;

import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.NullnessCasts;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.UnmodifiableIterator;
import io.opentelemetry.testing.internal.errorprone.annotations.CanIgnoreReturnValue;
import java.util.NoSuchElementException;
import org.jspecify.annotations.Nullable;

public abstract class AbstractIterator<T>
extends UnmodifiableIterator<T> {
    private State state = State.NOT_READY;
    private @Nullable T next;

    protected AbstractIterator() {
    }

    protected abstract @Nullable T computeNext();

    @CanIgnoreReturnValue
    protected final @Nullable T endOfData() {
        this.state = State.DONE;
        return null;
    }

    @Override
    public final boolean hasNext() {
        Preconditions.checkState(this.state != State.FAILED);
        switch (this.state.ordinal()) {
            case 2: {
                return false;
            }
            case 0: {
                return true;
            }
        }
        return this.tryToComputeNext();
    }

    private boolean tryToComputeNext() {
        this.state = State.FAILED;
        this.next = this.computeNext();
        if (this.state != State.DONE) {
            this.state = State.READY;
            return true;
        }
        return false;
    }

    @Override
    @CanIgnoreReturnValue
    public final T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.state = State.NOT_READY;
        T result = NullnessCasts.uncheckedCastNullableTToT(this.next);
        this.next = null;
        return result;
    }

    private static final class State
    extends Enum<State> {
        public static final /* enum */ State READY = new State();
        public static final /* enum */ State NOT_READY = new State();
        public static final /* enum */ State DONE = new State();
        public static final /* enum */ State FAILED = new State();
        private static final /* synthetic */ State[] $VALUES;

        private static /* synthetic */ State[] $values() {
            return new State[]{READY, NOT_READY, DONE, FAILED};
        }

        static {
            $VALUES = State.$values();
        }
    }
}

