/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util.encoders;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util.Strings;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util.encoders.DecoderException;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util.encoders.EncoderException;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util.encoders.HexEncoder;
import java.io.ByteArrayOutputStream;

public class Hex {
    private static final HexEncoder encoder = new HexEncoder();

    public static String toHexString(byte[] byArray) {
        return Hex.toHexString(byArray, 0, byArray.length);
    }

    public static String toHexString(byte[] byArray, int n, int n2) {
        byte[] byArray2 = Hex.encode(byArray, n, n2);
        return Strings.fromByteArray(byArray2);
    }

    public static byte[] encode(byte[] byArray) {
        return Hex.encode(byArray, 0, byArray.length);
    }

    public static byte[] encode(byte[] byArray, int n, int n2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            encoder.encode(byArray, n, n2, byteArrayOutputStream);
        }
        catch (Exception exception) {
            throw new EncoderException("exception encoding Hex string: " + exception.getMessage(), exception);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] decodeStrict(String string) {
        try {
            return encoder.decodeStrict(string, 0, string.length());
        }
        catch (Exception exception) {
            throw new DecoderException("exception decoding Hex string: " + exception.getMessage(), exception);
        }
    }

    public static byte[] decodeStrict(String string, int n, int n2) {
        try {
            return encoder.decodeStrict(string, n, n2);
        }
        catch (Exception exception) {
            throw new DecoderException("exception decoding Hex string: " + exception.getMessage(), exception);
        }
    }
}

