/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.jcajce.provider.util;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.ASN1Set;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.params.AsymmetricKeyParameter;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;

public class KeyUtil {
    public static byte[] getEncodedSubjectPublicKeyInfo(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        try {
            return subjectPublicKeyInfo.getEncoded("DER");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static byte[] getEncodedSubjectPublicKeyInfo(AsymmetricKeyParameter asymmetricKeyParameter) {
        if (asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("private key found");
        }
        try {
            return KeyUtil.getEncodedSubjectPublicKeyInfo(SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(asymmetricKeyParameter));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static byte[] getEncodedPrivateKeyInfo(PrivateKeyInfo privateKeyInfo) {
        try {
            return privateKeyInfo.getEncoded("DER");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static byte[] getEncodedPrivateKeyInfo(AsymmetricKeyParameter asymmetricKeyParameter, ASN1Set aSN1Set) {
        if (!asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("public key found");
        }
        try {
            return KeyUtil.getEncodedPrivateKeyInfo(PrivateKeyInfoFactory.createPrivateKeyInfo(asymmetricKeyParameter, aSN1Set));
        }
        catch (Exception exception) {
            return null;
        }
    }
}

