/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.jcajce.provider.kyber;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.ASN1Set;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.mlkem.MLKEMPrivateKeyParameters;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.jcajce.interfaces.KyberPrivateKey;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util.Arrays;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util.Strings;
import java.io.IOException;

public class BCKyberPrivateKey
implements KyberPrivateKey {
    private transient MLKEMPrivateKeyParameters params;
    private transient String algorithm;
    private transient ASN1Set attributes;

    public BCKyberPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.init(privateKeyInfo);
    }

    private void init(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.attributes = privateKeyInfo.getAttributes();
        this.params = (MLKEMPrivateKeyParameters)PrivateKeyFactory.createKey(privateKeyInfo);
        this.algorithm = Strings.toUpperCase(this.params.getParameters().getName());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCKyberPrivateKey) {
            BCKyberPrivateKey bCKyberPrivateKey = (BCKyberPrivateKey)object;
            return Arrays.areEqual(this.getEncoded(), bCKyberPrivateKey.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.getEncoded());
    }

    @Override
    public final String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public byte[] getEncoded() {
        try {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(this.params, this.attributes);
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }
}

