/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.rainbow;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.rainbow.RainbowKeyParameters;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.rainbow.RainbowParameters;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.rainbow.RainbowUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.rainbow.Version;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util.Arrays;

public class RainbowPublicKeyParameters
extends RainbowKeyParameters {
    short[][][] pk;
    byte[] pk_seed;
    short[][][] l1_Q3;
    short[][][] l1_Q5;
    short[][][] l1_Q6;
    short[][][] l1_Q9;
    short[][][] l2_Q9;

    public RainbowPublicKeyParameters(RainbowParameters rainbowParameters, byte[] byArray) {
        super(false, rainbowParameters);
        int n = rainbowParameters.getM();
        int n2 = rainbowParameters.getN();
        if (this.getParameters().getVersion() == Version.CLASSIC) {
            this.pk = new short[n][n2][n2];
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n2; ++j) {
                    for (int k = 0; k < n; ++k) {
                        if (i > j) {
                            this.pk[k][i][j] = 0;
                            continue;
                        }
                        this.pk[k][i][j] = (short)(byArray[n3] & 0xFF);
                        ++n3;
                    }
                }
            }
        } else {
            this.pk_seed = Arrays.copyOfRange(byArray, 0, rainbowParameters.getLen_pkseed());
            this.l1_Q3 = new short[rainbowParameters.getO1()][rainbowParameters.getV1()][rainbowParameters.getO2()];
            this.l1_Q5 = new short[rainbowParameters.getO1()][rainbowParameters.getO1()][rainbowParameters.getO1()];
            this.l1_Q6 = new short[rainbowParameters.getO1()][rainbowParameters.getO1()][rainbowParameters.getO2()];
            this.l1_Q9 = new short[rainbowParameters.getO1()][rainbowParameters.getO2()][rainbowParameters.getO2()];
            this.l2_Q9 = new short[rainbowParameters.getO2()][rainbowParameters.getO2()][rainbowParameters.getO2()];
            int n4 = rainbowParameters.getLen_pkseed();
            n4 += RainbowUtil.loadEncoded(this.l1_Q3, byArray, n4, false);
            n4 += RainbowUtil.loadEncoded(this.l1_Q5, byArray, n4, true);
            n4 += RainbowUtil.loadEncoded(this.l1_Q6, byArray, n4, false);
            n4 += RainbowUtil.loadEncoded(this.l1_Q9, byArray, n4, true);
            if ((n4 += RainbowUtil.loadEncoded(this.l2_Q9, byArray, n4, true)) != byArray.length) {
                throw new IllegalArgumentException("unparsed data in key encoding");
            }
        }
    }

    public byte[] getEncoded() {
        if (this.getParameters().getVersion() != Version.CLASSIC) {
            byte[] byArray = this.pk_seed;
            byArray = Arrays.concatenate(byArray, RainbowUtil.getEncoded(this.l1_Q3, false));
            byArray = Arrays.concatenate(byArray, RainbowUtil.getEncoded(this.l1_Q5, true));
            byArray = Arrays.concatenate(byArray, RainbowUtil.getEncoded(this.l1_Q6, false));
            byArray = Arrays.concatenate(byArray, RainbowUtil.getEncoded(this.l1_Q9, true));
            byArray = Arrays.concatenate(byArray, RainbowUtil.getEncoded(this.l2_Q9, true));
            return byArray;
        }
        return RainbowUtil.getEncoded(this.pk, true);
    }
}

