/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.mlkem;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.mlkem.CBD;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.mlkem.MLKEMEngine;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.mlkem.Ntt;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.mlkem.Reduce;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.mlkem.Symmetric;

class Poly {
    private short[] coeffs = new short[256];
    private MLKEMEngine engine;
    private int polyCompressedBytes;
    private int eta1;
    private int eta2;
    private Symmetric symmetric;

    public Poly(MLKEMEngine mLKEMEngine) {
        this.engine = mLKEMEngine;
        this.polyCompressedBytes = mLKEMEngine.getKyberPolyCompressedBytes();
        this.eta1 = mLKEMEngine.getKyberEta1();
        this.eta2 = MLKEMEngine.getKyberEta2();
        this.symmetric = mLKEMEngine.getSymmetric();
    }

    public short getCoeffIndex(int n) {
        return this.coeffs[n];
    }

    public short[] getCoeffs() {
        return this.coeffs;
    }

    public void setCoeffIndex(int n, short s) {
        this.coeffs[n] = s;
    }

    public void setCoeffs(short[] sArray) {
        this.coeffs = sArray;
    }

    public void polyNtt() {
        this.setCoeffs(Ntt.ntt(this.getCoeffs()));
        this.reduce();
    }

    public void reduce() {
        for (int i = 0; i < 256; ++i) {
            this.setCoeffIndex(i, Reduce.barretReduce(this.getCoeffIndex(i)));
        }
    }

    public static void baseMultMontgomery(Poly poly, Poly poly2, Poly poly3) {
        for (int i = 0; i < 64; ++i) {
            Ntt.baseMult(poly, 4 * i, poly2.getCoeffIndex(4 * i), poly2.getCoeffIndex(4 * i + 1), poly3.getCoeffIndex(4 * i), poly3.getCoeffIndex(4 * i + 1), Ntt.nttZetas[64 + i]);
            Ntt.baseMult(poly, 4 * i + 2, poly2.getCoeffIndex(4 * i + 2), poly2.getCoeffIndex(4 * i + 3), poly3.getCoeffIndex(4 * i + 2), poly3.getCoeffIndex(4 * i + 3), (short)(-1 * Ntt.nttZetas[64 + i]));
        }
    }

    public void addCoeffs(Poly poly) {
        for (int i = 0; i < 256; ++i) {
            this.setCoeffIndex(i, (short)(this.getCoeffIndex(i) + poly.getCoeffIndex(i)));
        }
    }

    public void convertToMont() {
        for (int i = 0; i < 256; ++i) {
            this.setCoeffIndex(i, Reduce.montgomeryReduce(this.getCoeffIndex(i) * 1353));
        }
    }

    public byte[] toBytes() {
        byte[] byArray = new byte[384];
        this.conditionalSubQ();
        for (int i = 0; i < 128; ++i) {
            short s = this.getCoeffIndex(2 * i);
            short s2 = this.getCoeffIndex(2 * i + 1);
            byArray[3 * i] = (byte)(s >> 0);
            byArray[3 * i + 1] = (byte)(s >> 8 | s2 << 4);
            byArray[3 * i + 2] = (byte)(s2 >> 4);
        }
        return byArray;
    }

    public void conditionalSubQ() {
        for (int i = 0; i < 256; ++i) {
            this.setCoeffIndex(i, Reduce.conditionalSubQ(this.getCoeffIndex(i)));
        }
    }

    public void getEta1Noise(byte[] byArray, byte by) {
        byte[] byArray2 = new byte[256 * this.eta1 / 4];
        this.symmetric.prf(byArray2, byArray, by);
        CBD.mlkemCBD(this, byArray2, this.eta1);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < this.coeffs.length; ++i) {
            stringBuffer.append(this.coeffs[i]);
            if (i == this.coeffs.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

