/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.lms;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.lms.LMOtsParameters;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.lms.LMOtsSignature;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.lms.LMSContext;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.lms.LMSPrivateKeyParameters;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.lms.LMSSignature;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.lms.LMSigParameters;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.lms.LM_OTS;

class LMS {
    public static LMSPrivateKeyParameters generateKeys(LMSigParameters lMSigParameters, LMOtsParameters lMOtsParameters, int n, byte[] byArray, byte[] byArray2) throws IllegalArgumentException {
        if (byArray2 == null || byArray2.length < lMSigParameters.getM()) {
            throw new IllegalArgumentException("root seed is less than " + lMSigParameters.getM());
        }
        int n2 = 1 << lMSigParameters.getH();
        return new LMSPrivateKeyParameters(lMSigParameters, lMOtsParameters, n, byArray, n2, byArray2);
    }

    public static LMSSignature generateSign(LMSPrivateKeyParameters lMSPrivateKeyParameters, byte[] byArray) {
        LMSContext lMSContext = lMSPrivateKeyParameters.generateLMSContext();
        lMSContext.update(byArray, 0, byArray.length);
        return LMS.generateSign(lMSContext);
    }

    public static LMSSignature generateSign(LMSContext lMSContext) {
        LMOtsSignature lMOtsSignature = LM_OTS.lm_ots_generate_signature(lMSContext.getPrivateKey(), lMSContext.getQ(), lMSContext.getC());
        return new LMSSignature(lMSContext.getPrivateKey().getQ(), lMOtsSignature, lMSContext.getSigParams(), lMSContext.getPath());
    }
}

