/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.pqc.crypto.bike;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.math.raw.Mod;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util.Integers;
import java.util.HashMap;
import java.util.Map;

class BIKERing {
    private final int bits;
    private final int size;
    private final int sizeExt;
    private final Map<Integer, Integer> halfPowers = new HashMap<Integer, Integer>();

    BIKERing(int n) {
        if ((n & 0xFFFF0001) != 1) {
            throw new IllegalArgumentException();
        }
        this.bits = n;
        this.size = n + 63 >>> 6;
        this.sizeExt = this.size * 2;
        BIKERing.generateHalfPowersInv(this.halfPowers, n);
    }

    private static int generateHalfPower(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = 1;
        for (n5 = n3; n5 >= 32; n5 -= 32) {
            n4 = n2 * n6;
            long l = ((long)n4 & 0xFFFFFFFFL) * (long)n;
            long l2 = l + (long)n6;
            n6 = (int)(l2 >>> 32);
        }
        if (n5 > 0) {
            n4 = -1 >>> -n5;
            int n7 = n2 * n6 & n4;
            long l = ((long)n7 & 0xFFFFFFFFL) * (long)n;
            long l3 = l + (long)n6;
            n6 = (int)(l3 >>> n5);
        }
        return n6;
    }

    private static void generateHalfPowersInv(Map<Integer, Integer> map, int n) {
        int n2 = n - 2;
        int n3 = 32 - Integers.numberOfLeadingZeros(n2);
        int n4 = Mod.inverse32(-n);
        for (int i = 1; i < n3; ++i) {
            int n5;
            int n6 = 1 << i - 1;
            if (n6 >= 64 && !map.containsKey(Integers.valueOf(n6))) {
                map.put(Integers.valueOf(n6), Integers.valueOf(BIKERing.generateHalfPower(n, n4, n6)));
            }
            if ((n2 & 1 << i) == 0 || (n5 = n2 & (1 << i) - 1) < 64 || map.containsKey(Integers.valueOf(n5))) continue;
            map.put(Integers.valueOf(n5), Integers.valueOf(BIKERing.generateHalfPower(n, n4, n5)));
        }
    }
}

