/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.jcajce.provider.config;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util.Strings;
import java.security.BasicPermission;
import java.security.Permission;
import java.util.StringTokenizer;

public class ProviderConfigurationPermission
extends BasicPermission {
    private final String actions;
    private final int permissionMask;

    public ProviderConfigurationPermission(String string, String string2) {
        super(string, string2);
        this.actions = string2;
        this.permissionMask = this.calculateMask(string2);
    }

    private int calculateMask(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(Strings.toLowerCase(string), " ,");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("threadlocalecimplicitlyca")) {
                n |= 1;
                continue;
            }
            if (string2.equals("ecimplicitlyca")) {
                n |= 2;
                continue;
            }
            if (string2.equals("threadlocaldhdefaultparams")) {
                n |= 4;
                continue;
            }
            if (string2.equals("dhdefaultparams")) {
                n |= 8;
                continue;
            }
            if (string2.equals("acceptableeccurves")) {
                n |= 0x10;
                continue;
            }
            if (string2.equals("additionalecparameters")) {
                n |= 0x20;
                continue;
            }
            if (!string2.equals("all")) continue;
            n |= 0x3F;
        }
        if (n == 0) {
            throw new IllegalArgumentException("unknown permissions passed to mask");
        }
        return n;
    }

    @Override
    public String getActions() {
        return this.actions;
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof ProviderConfigurationPermission)) {
            return false;
        }
        if (!this.getName().equals(permission.getName())) {
            return false;
        }
        ProviderConfigurationPermission providerConfigurationPermission = (ProviderConfigurationPermission)permission;
        return (this.permissionMask & providerConfigurationPermission.permissionMask) == providerConfigurationPermission.permissionMask;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ProviderConfigurationPermission) {
            ProviderConfigurationPermission providerConfigurationPermission = (ProviderConfigurationPermission)object;
            return this.permissionMask == providerConfigurationPermission.permissionMask && this.getName().equals(providerConfigurationPermission.getName());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode() + this.permissionMask;
    }
}

