/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.params;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.params.AsymmetricKeyParameter;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.math.ec.rfc8032.Ed25519;

public final class Ed25519PublicKeyParameters
extends AsymmetricKeyParameter {
    private final Ed25519.PublicPoint publicPoint;

    public Ed25519PublicKeyParameters(byte[] byArray, int n) {
        super(false);
        this.publicPoint = Ed25519PublicKeyParameters.parse(byArray, n);
    }

    public Ed25519PublicKeyParameters(Ed25519.PublicPoint publicPoint) {
        super(false);
        if (publicPoint == null) {
            throw new NullPointerException("'publicPoint' cannot be null");
        }
        this.publicPoint = publicPoint;
    }

    public void encode(byte[] byArray, int n) {
        Ed25519.encodePublicPoint(this.publicPoint, byArray, n);
    }

    public byte[] getEncoded() {
        byte[] byArray = new byte[32];
        this.encode(byArray, 0);
        return byArray;
    }

    private static Ed25519.PublicPoint parse(byte[] byArray, int n) {
        Ed25519.PublicPoint publicPoint = Ed25519.validatePublicKeyPartialExport(byArray, n);
        if (publicPoint == null) {
            throw new IllegalArgumentException("invalid public key");
        }
        return publicPoint;
    }
}

