/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.cert.jcajce;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.cert.X509CertificateHolder;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.cert.jcajce.CertHelper;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.cert.jcajce.DefaultCertHelper;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.cert.jcajce.ProviderCertHelper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;

public class JcaX509CertificateConverter {
    private CertHelper helper = new DefaultCertHelper();

    public JcaX509CertificateConverter setProvider(Provider provider) {
        this.helper = new ProviderCertHelper(provider);
        return this;
    }

    public X509Certificate getCertificate(X509CertificateHolder x509CertificateHolder) throws CertificateException {
        try {
            CertificateFactory certificateFactory = this.helper.getCertificateFactory("X.509");
            return (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(x509CertificateHolder.getEncoded()));
        }
        catch (IOException iOException) {
            throw new ExCertificateParsingException("exception parsing certificate: " + iOException.getMessage(), iOException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new ExCertificateException("cannot find required provider:" + noSuchProviderException.getMessage(), noSuchProviderException);
        }
    }

    private static class ExCertificateException
    extends CertificateException {
        private Throwable cause;

        public ExCertificateException(String string, Throwable throwable) {
            super(string);
            this.cause = throwable;
        }

        @Override
        public Throwable getCause() {
            return this.cause;
        }
    }

    private static class ExCertificateParsingException
    extends CertificateParsingException {
        private Throwable cause;

        public ExCertificateParsingException(String string, Throwable throwable) {
            super(string);
            this.cause = throwable;
        }

        @Override
        public Throwable getCause() {
            return this.cause;
        }
    }
}

