/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.x509;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.ASN1Integer;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.DERBitString;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.DERSequence;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.DERTaggedObject;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.x500.X500Name;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.x509.AlgorithmIdentifier;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.x509.Extension;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.x509.Extensions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.x509.TBSCertificate;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.x509.Time;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.x509.Validity;

public class V3TBSCertificateGenerator {
    private static final DERTaggedObject VERSION = new DERTaggedObject(true, 0, new ASN1Integer(2L));
    ASN1Integer serialNumber;
    AlgorithmIdentifier signature;
    X500Name issuer;
    Validity validity;
    Time startDate;
    Time endDate;
    X500Name subject;
    SubjectPublicKeyInfo subjectPublicKeyInfo;
    Extensions extensions;
    private boolean altNamePresentAndCritical;
    private DERBitString issuerUniqueID;
    private DERBitString subjectUniqueID;

    public void setSerialNumber(ASN1Integer aSN1Integer) {
        this.serialNumber = aSN1Integer;
    }

    public void setSignature(AlgorithmIdentifier algorithmIdentifier) {
        this.signature = algorithmIdentifier;
    }

    public void setIssuer(X500Name x500Name) {
        this.issuer = x500Name;
    }

    public void setStartDate(Time time) {
        this.validity = null;
        this.startDate = time;
    }

    public void setEndDate(Time time) {
        this.validity = null;
        this.endDate = time;
    }

    public void setSubject(X500Name x500Name) {
        this.subject = x500Name;
    }

    public void setSubjectPublicKeyInfo(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.subjectPublicKeyInfo = subjectPublicKeyInfo;
    }

    public void setExtensions(Extensions extensions) {
        Extension extension;
        this.extensions = extensions;
        if (extensions != null && (extension = extensions.getExtension(Extension.subjectAlternativeName)) != null && extension.isCritical()) {
            this.altNamePresentAndCritical = true;
        }
    }

    public TBSCertificate generateTBSCertificate() {
        if (this.serialNumber == null || this.signature == null || this.issuer == null || this.validity == null && (this.startDate == null || this.endDate == null) || this.subject == null && !this.altNamePresentAndCritical || this.subjectPublicKeyInfo == null) {
            throw new IllegalStateException("not all mandatory fields set in V3 TBScertificate generator");
        }
        return new TBSCertificate(new ASN1Integer(2L), this.serialNumber, this.signature, this.issuer, this.validity != null ? this.validity : new Validity(this.startDate, this.endDate), this.subject != null ? this.subject : X500Name.getInstance(new DERSequence()), this.subjectPublicKeyInfo, this.issuerUniqueID, this.subjectUniqueID, this.extensions);
    }
}

