/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.ASN1Object;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.ASN1TaggedObject;

public abstract class ASN1Util {
    static ASN1TaggedObject checkContextTagClass(ASN1TaggedObject aSN1TaggedObject) {
        return ASN1Util.checkTagClass(aSN1TaggedObject, 128);
    }

    static ASN1TaggedObject checkTagClass(ASN1TaggedObject aSN1TaggedObject, int n) {
        if (!aSN1TaggedObject.hasTagClass(n)) {
            String string = ASN1Util.getTagClassText(n);
            String string2 = ASN1Util.getTagClassText(aSN1TaggedObject);
            throw new IllegalStateException("Expected " + string + " tag but found " + string2);
        }
        return aSN1TaggedObject;
    }

    public static Object getInstanceChoiceBaseObject(ASN1TaggedObject aSN1TaggedObject, boolean bl, String string) {
        if (!bl) {
            String string2 = "Implicit tagging cannot be used with untagged choice type " + string + " (X.680 30.6, 30.8).";
            throw new IllegalArgumentException(string2);
        }
        if (aSN1TaggedObject == null) {
            throw new NullPointerException("'taggedObject' cannot be null");
        }
        return ASN1Util.getExplicitContextBaseObject(aSN1TaggedObject);
    }

    public static String getTagClassText(ASN1TaggedObject aSN1TaggedObject) {
        return ASN1Util.getTagClassText(aSN1TaggedObject.getTagClass());
    }

    public static String getTagClassText(int n) {
        switch (n) {
            case 64: {
                return "APPLICATION";
            }
            case 128: {
                return "CONTEXT";
            }
            case 192: {
                return "PRIVATE";
            }
        }
        return "UNIVERSAL";
    }

    public static String getTagText(ASN1TaggedObject aSN1TaggedObject) {
        return ASN1Util.getTagText(aSN1TaggedObject.getTagClass(), aSN1TaggedObject.getTagNo());
    }

    public static String getTagText(int n, int n2) {
        switch (n) {
            case 64: {
                return "[APPLICATION " + n2 + "]";
            }
            case 128: {
                return "[CONTEXT " + n2 + "]";
            }
            case 192: {
                return "[PRIVATE " + n2 + "]";
            }
        }
        return "[UNIVERSAL " + n2 + "]";
    }

    public static ASN1Object getExplicitBaseObject(ASN1TaggedObject aSN1TaggedObject, int n) {
        return ASN1Util.checkTagClass(aSN1TaggedObject, n).getExplicitBaseObject();
    }

    public static ASN1Object getExplicitContextBaseObject(ASN1TaggedObject aSN1TaggedObject) {
        return ASN1Util.getExplicitBaseObject(aSN1TaggedObject, 128);
    }
}

