/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.server.annotation;

import io.opentelemetry.testing.internal.armeria.common.HttpHeaderNames;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.HttpStatus;
import io.opentelemetry.testing.internal.armeria.common.MediaType;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeaders;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeadersBuilder;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import io.opentelemetry.testing.internal.armeria.server.annotation.AnnotatedService;
import io.opentelemetry.testing.internal.armeria.server.annotation.HttpResult;

final class HttpResultUtil {
    static ResponseHeaders buildResponseHeaders(ServiceRequestContext ctx, HttpResult<?> result) {
        ResponseHeadersBuilder builder;
        HttpHeaders customHeaders = result.headers();
        if (customHeaders instanceof ResponseHeaders) {
            builder = ((ResponseHeaders)customHeaders).toBuilder();
        } else {
            builder = ResponseHeaders.builder();
            builder.add((Iterable)customHeaders);
            if (!builder.contains(HttpHeaderNames.STATUS)) {
                AnnotatedService service = ctx.config().service().as(AnnotatedService.class);
                if (service != null) {
                    builder.status(service.defaultStatus());
                } else {
                    builder.status(HttpStatus.OK);
                }
            }
        }
        return HttpResultUtil.maybeAddContentType(ctx, builder).build();
    }

    private static ResponseHeadersBuilder maybeAddContentType(ServiceRequestContext ctx, ResponseHeadersBuilder builder) {
        if (builder.status().isContentAlwaysEmpty()) {
            return builder;
        }
        if (builder.contentType() != null) {
            return builder;
        }
        MediaType negotiatedResponseMediaType = ctx.negotiatedResponseMediaType();
        if (negotiatedResponseMediaType != null) {
            builder.contentType(negotiatedResponseMediaType);
        }
        return builder;
    }

    private HttpResultUtil() {
    }
}

