/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.server.annotation;

import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.common.logging.BeanFieldMaskerSelector;
import io.opentelemetry.testing.internal.armeria.internal.common.logging.FieldMaskerSelectorProvider;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.AnnotatedRequestJsonSerializer;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.AnnotatedResponseJsonSerializer;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.AnnotatedServiceLogUtil;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.BeanFieldMaskerCache;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.MaskingBeanDeserializerModifier;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.MaskingBeanSerializerModifier;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.RpcRequestSerializer;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.RpcResponseSerializer;
import io.opentelemetry.testing.internal.jackson.databind.ObjectMapper;
import io.opentelemetry.testing.internal.jackson.databind.SerializationFeature;
import io.opentelemetry.testing.internal.jackson.databind.module.SimpleModule;
import java.util.List;

@UnstableApi
public final class BeanFieldMaskerSelectorProvider
implements FieldMaskerSelectorProvider<BeanFieldMaskerSelector> {
    @Override
    public Class<BeanFieldMaskerSelector> supportedType() {
        return BeanFieldMaskerSelector.class;
    }

    @Override
    public void customize(List<BeanFieldMaskerSelector> selectors, ObjectMapper objectMapper) {
        SimpleModule module = new SimpleModule("bean-field-masker-selector");
        BeanFieldMaskerCache maskerCache = new BeanFieldMaskerCache(selectors);
        module.setSerializerModifier(new MaskingBeanSerializerModifier(maskerCache));
        module.setDeserializerModifier(new MaskingBeanDeserializerModifier(maskerCache));
        module.addSerializer(new AnnotatedRequestJsonSerializer(maskerCache));
        module.addSerializer(new AnnotatedResponseJsonSerializer(maskerCache));
        module.addSerializer(RpcRequestSerializer.INSTANCE);
        module.addSerializer(RpcResponseSerializer.INSTANCE);
        AnnotatedServiceLogUtil.customizeWellKnownSerializers(module);
        objectMapper.registerModule(module);
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
    }
}

