/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.server.annotation;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.util.Exceptions;
import io.opentelemetry.testing.internal.armeria.internal.common.util.StringUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableMap;
import io.opentelemetry.testing.internal.io.netty.util.AsciiString;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Stream;

final class AnnotatedServiceTypeUtil {
    private static final Map<Class<?>, Function<String, ?>> supportedElementTypes = ImmutableMap.builder().put(Byte.TYPE, Byte::valueOf).put(Byte.class, Byte::valueOf).put(Short.TYPE, Short::valueOf).put(Short.class, Short::valueOf).put(Boolean.TYPE, s -> StringUtil.toBoolean(s)).put(Boolean.class, s -> StringUtil.toBoolean(s)).put(Integer.TYPE, Integer::valueOf).put(Integer.class, Integer::valueOf).put(Long.TYPE, Long::valueOf).put(Long.class, Long::valueOf).put(Float.TYPE, Float::valueOf).put(Float.class, Float::valueOf).put(Double.TYPE, Double::valueOf).put(Double.class, Double::valueOf).put(UUID.class, UUID::fromString).put(Duration.class, Duration::parse).put(Instant.class, Instant::parse).put(LocalDate.class, LocalDate::parse).put(LocalDateTime.class, LocalDateTime::parse).put(LocalTime.class, LocalTime::parse).put(OffsetDateTime.class, OffsetDateTime::parse).put(OffsetTime.class, OffsetTime::parse).put(Period.class, Period::parse).put(ZonedDateTime.class, ZonedDateTime::parse).put(ZoneId.class, ZoneId::of).put(ZoneOffset.class, ZoneOffset::of).put(AsciiString.class, AsciiString::new).put(String.class, Function.identity()).put(CharSequence.class, Function.identity()).put(Object.class, Function.identity()).build();
    private static final ClassValue<Function<String, ?>> convertExternalTypes = new ClassValue<Function<String, ?>>(){

        @Override
        @Nullable
        protected Function<String, ?> computeValue(Class<?> type) {
            return AnnotatedServiceTypeUtil.getCreatorMethod(type);
        }
    };

    @Nullable
    private static <T> MethodHandle getPublicStaticMethodHandle(Class<T> clazz, String methodName) {
        try {
            MethodType methodType = MethodType.methodType(clazz, String.class);
            return MethodHandles.publicLookup().findStatic(clazz, methodName, methodType);
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Nullable
    private static <T> MethodHandle getStringConstructorMethodHandle(Class<T> clazz) {
        try {
            MethodType methodType = MethodType.methodType(Void.TYPE, String.class);
            return MethodHandles.publicLookup().findConstructor(clazz, methodType);
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Nullable
    static <T> Function<String, T> getCreatorMethod(Class<T> clazz) {
        MethodHandle methodHandle = Stream.of("of", "valueOf", "fromString").map(methodName -> AnnotatedServiceTypeUtil.getPublicStaticMethodHandle(clazz, methodName)).filter(Objects::nonNull).findFirst().orElseGet(() -> AnnotatedServiceTypeUtil.getStringConstructorMethodHandle(clazz));
        if (methodHandle == null) {
            return null;
        }
        return str -> {
            try {
                return methodHandle.invokeWithArguments(str);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                assert (cause != null);
                return Exceptions.throwUnsafely(cause);
            }
            catch (Throwable t) {
                return Exceptions.throwUnsafely(t);
            }
        };
    }

    static <T> T stringToType(String str, Class<T> clazz) {
        try {
            Function<String, ?> func = supportedElementTypes.get(clazz);
            if (func == null) {
                func = convertExternalTypes.get(clazz);
            }
            if (func != null) {
                return (T)func.apply(str);
            }
        }
        catch (NumberFormatException e) {
            throw e;
        }
        catch (Throwable cause) {
            throw new IllegalArgumentException("Can't convert '" + str + "' to type '" + clazz.getSimpleName() + "'.", cause);
        }
        throw new IllegalArgumentException("Can't convert '" + str + "' to type '" + clazz.getSimpleName() + "'.");
    }

    private AnnotatedServiceTypeUtil() {
    }
}

