/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.server.annotation;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.logging.BeanFieldInfo;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.AnnotationUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Map;
import java.util.function.Function;

final class AnnotatedBeanFieldInfo
implements BeanFieldInfo {
    private final String httpElementName;
    private final Map<Class<?>, Annotation> typeElementMap;
    private final Map<Class<?>, Annotation> typeMap;

    AnnotatedBeanFieldInfo(AnnotatedElement typeElement, Class<?> type, String httpElementName) {
        this.httpElementName = httpElementName;
        this.typeElementMap = AnnotatedBeanFieldInfo.annotationMap(typeElement);
        this.typeMap = AnnotatedBeanFieldInfo.annotationMap(type);
    }

    private static Map<Class<?>, Annotation> annotationMap(AnnotatedElement annotatedElement) {
        return AnnotationUtil.getAllAnnotations(annotatedElement).stream().collect(ImmutableMap.toImmutableMap(Annotation::annotationType, Function.identity(), (a, b) -> a));
    }

    @Override
    public String name() {
        return this.httpElementName;
    }

    @Override
    @Nullable
    public <T extends Annotation> T getFieldAnnotation(Class<T> annotationClass) {
        return (T)this.typeElementMap.get(annotationClass);
    }

    @Override
    @Nullable
    public <T extends Annotation> T getClassAnnotation(Class<T> annotationClass) {
        return (T)this.typeMap.get(annotationClass);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("httpElementName", this.httpElementName).add("typeElementMap", this.typeElementMap).add("typeMap", this.typeMap).toString();
    }
}

