/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.server.annotation;

import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.MediaType;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.util.Exceptions;
import io.opentelemetry.testing.internal.armeria.internal.common.util.ObjectCollectingUtil;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.ClassUtil;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import io.opentelemetry.testing.internal.armeria.server.annotation.ResponseConverterFunction;
import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;

final class AggregatedResponseConverterFunction
implements ResponseConverterFunction {
    private final ResponseConverterFunction responseConverter;

    AggregatedResponseConverterFunction(ResponseConverterFunction responseConverter) {
        this.responseConverter = responseConverter;
    }

    @Override
    @Nullable
    public Boolean isResponseStreaming(Type returnType, @Nullable MediaType contentType) {
        Class<?> clazz = ClassUtil.typeToClass(ClassUtil.unwrapUnaryAsyncType(returnType));
        if (clazz == null) {
            return null;
        }
        if (HttpResponse.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Publisher.class.isAssignableFrom(clazz) || Stream.class.isAssignableFrom(clazz)) {
            return false;
        }
        return null;
    }

    @Override
    public HttpResponse convertResponse(ServiceRequestContext ctx, ResponseHeaders headers, @Nullable Object result, HttpHeaders trailers) throws Exception {
        CompletableFuture<Object> f;
        if (result instanceof Publisher) {
            f = ObjectCollectingUtil.collectFrom((Publisher)result, ctx);
        } else if (result instanceof Stream) {
            f = ObjectCollectingUtil.collectFrom((Stream)result, ctx.blockingTaskExecutor());
        } else {
            return (HttpResponse)ResponseConverterFunction.fallthrough();
        }
        return HttpResponse.of((CompletableFuture<? extends HttpResponse>)f.thenApply(aggregated -> {
            try {
                return this.responseConverter.convertResponse(ctx, headers, aggregated, trailers);
            }
            catch (Exception ex) {
                return (HttpResponse)Exceptions.throwUnsafely(ex);
            }
        }));
    }
}

