/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.common.util;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.io.netty.util.NetUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public final class IpAddrUtil {
    @Nullable
    public static String normalize(@Nullable String ipAddr) {
        if (ipAddr == null) {
            return null;
        }
        byte[] array = NetUtil.createByteArrayFromIpAddressString(ipAddr);
        if (array == null) {
            return null;
        }
        return NetUtil.bytesToIpAddress(array);
    }

    public static boolean isCreatedWithIpAddressOnly(InetSocketAddress socketAddress) {
        if (socketAddress.isUnresolved()) {
            return false;
        }
        InetAddress inetAddress = socketAddress.getAddress();
        return socketAddress.getHostString().equals(inetAddress.getHostAddress());
    }

    private IpAddrUtil() {
    }
}

