/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.common.metric;

import io.opentelemetry.testing.internal.armeria.common.HttpStatus;
import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.common.logging.RequestLog;
import io.opentelemetry.testing.internal.armeria.common.logging.RequestLogProperty;
import io.opentelemetry.testing.internal.armeria.common.logging.RequestOnlyLog;
import io.opentelemetry.testing.internal.armeria.common.metric.MeterIdPrefix;
import io.opentelemetry.testing.internal.armeria.common.metric.MeterIdPrefixFunction;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.MeterRegistry;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.Tag;
import java.util.Objects;

public final class DefaultMeterIdPrefixFunction
implements MeterIdPrefixFunction {
    private final String name;

    public static MeterIdPrefixFunction of(String name) {
        return new DefaultMeterIdPrefixFunction(name);
    }

    private DefaultMeterIdPrefixFunction(String name) {
        this.name = Objects.requireNonNull(name, "name");
    }

    @Override
    public MeterIdPrefix activeRequestPrefix(MeterRegistry registry, RequestOnlyLog log) {
        ImmutableList.Builder<Tag> tagListBuilder = ImmutableList.builderWithExpectedSize(3);
        DefaultMeterIdPrefixFunction.addActiveRequestPrefixTags(tagListBuilder, log);
        return new MeterIdPrefix(this.name, tagListBuilder.build());
    }

    @Override
    public MeterIdPrefix completeRequestPrefix(MeterRegistry registry, RequestLog log) {
        ImmutableList.Builder<Tag> tagListBuilder = ImmutableList.builderWithExpectedSize(4);
        DefaultMeterIdPrefixFunction.addCompleteRequestPrefixTags(tagListBuilder, log);
        return new MeterIdPrefix(this.name, tagListBuilder.build());
    }

    public static void addActiveRequestPrefixTags(ImmutableList.Builder<Tag> tagListBuilder, RequestOnlyLog log) {
        Objects.requireNonNull(tagListBuilder, "tagListBuilder");
        Objects.requireNonNull(log, "log");
        DefaultMeterIdPrefixFunction.addHostnamePattern(tagListBuilder, log);
        DefaultMeterIdPrefixFunction.addMethodAndService(tagListBuilder, log);
    }

    public static void addCompleteRequestPrefixTags(ImmutableList.Builder<Tag> tagListBuilder, RequestLog log) {
        Objects.requireNonNull(tagListBuilder, "tagListBuilder");
        Objects.requireNonNull(log, "log");
        DefaultMeterIdPrefixFunction.addHostnamePattern(tagListBuilder, log);
        DefaultMeterIdPrefixFunction.addHttpStatus(tagListBuilder, log);
        DefaultMeterIdPrefixFunction.addMethodAndService(tagListBuilder, log);
    }

    public static void addHttpStatus(ImmutableList.Builder<Tag> tagListBuilder, RequestLog log) {
        Objects.requireNonNull(tagListBuilder, "tagListBuilder");
        Objects.requireNonNull(log, "log");
        HttpStatus status = log.isAvailable(RequestLogProperty.RESPONSE_HEADERS) ? log.responseHeaders().status() : HttpStatus.UNKNOWN;
        tagListBuilder.add((Object)Tag.of("http.status", status.codeAsText()));
    }

    private static void addHostnamePattern(ImmutableList.Builder<Tag> tagListBuilder, RequestOnlyLog log) {
        RequestContext ctx = log.context();
        if (ctx instanceof ServiceRequestContext) {
            ServiceRequestContext sCtx = (ServiceRequestContext)ctx;
            tagListBuilder.add((Object)Tag.of("hostname.pattern", sCtx.config().virtualHost().hostnamePattern()));
        }
    }

    private static void addMethodAndService(ImmutableList.Builder<Tag> tagListBuilder, RequestOnlyLog log) {
        tagListBuilder.add((Object)Tag.of("method", log.name()));
        tagListBuilder.add((Object)Tag.of("service", MoreObjects.firstNonNull(log.serviceName(), "none")));
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).toString();
    }
}

