/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.common;

import io.opentelemetry.testing.internal.armeria.common.AttributesGetters;
import io.opentelemetry.testing.internal.armeria.common.ConcurrentAttributes;
import io.opentelemetry.testing.internal.armeria.common.ExchangeType;
import io.opentelemetry.testing.internal.armeria.common.HttpMethod;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.Request;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.RequestId;
import io.opentelemetry.testing.internal.armeria.common.RequestTarget;
import io.opentelemetry.testing.internal.armeria.common.RequestTargetForm;
import io.opentelemetry.testing.internal.armeria.common.RpcRequest;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.internal.common.ArmeriaHttpUtil;
import io.opentelemetry.testing.internal.armeria.internal.common.RequestContextExtension;
import io.opentelemetry.testing.internal.armeria.internal.common.RequestContextUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.MeterRegistry;
import io.opentelemetry.testing.internal.io.netty.channel.Channel;
import io.opentelemetry.testing.internal.io.netty.util.AttributeKey;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Supplier;

public abstract class NonWrappingRequestContext
implements RequestContextExtension {
    private static final AtomicReferenceFieldUpdater<NonWrappingRequestContext, Supplier> contextHookUpdater = AtomicReferenceFieldUpdater.newUpdater(NonWrappingRequestContext.class, Supplier.class, "contextHook");
    private final MeterRegistry meterRegistry;
    private final ConcurrentAttributes attrs;
    private final RequestId id;
    private final HttpMethod method;
    private RequestTarget reqTarget;
    private final ExchangeType exchangeType;
    private long requestAutoAbortDelayMillis;
    @Nullable
    private String decodedPath;
    private final Request originalRequest;
    @Nullable
    private volatile HttpRequest req;
    @Nullable
    private volatile RpcRequest rpcReq;
    private volatile Supplier<AutoCloseable> contextHook;

    protected NonWrappingRequestContext(MeterRegistry meterRegistry, RequestId id, HttpMethod method, RequestTarget reqTarget, ExchangeType exchangeType, long requestAutoAbortDelayMillis, @Nullable HttpRequest req, @Nullable RpcRequest rpcReq, @Nullable AttributesGetters rootAttributeMap, Supplier<? extends AutoCloseable> contextHook) {
        assert (req != null || rpcReq != null);
        this.meterRegistry = Objects.requireNonNull(meterRegistry, "meterRegistry");
        this.attrs = rootAttributeMap == null ? ConcurrentAttributes.of() : ConcurrentAttributes.fromParent(rootAttributeMap);
        this.id = Objects.requireNonNull(id, "id");
        this.method = Objects.requireNonNull(method, "method");
        this.reqTarget = Objects.requireNonNull(reqTarget, "reqTarget");
        this.exchangeType = Objects.requireNonNull(exchangeType, "exchangeType");
        this.requestAutoAbortDelayMillis = requestAutoAbortDelayMillis;
        this.originalRequest = MoreObjects.firstNonNull(req, rpcReq);
        this.req = req;
        this.rpcReq = rpcReq;
        this.contextHook = contextHook;
    }

    @Override
    @Nullable
    public final HttpRequest request() {
        return this.req;
    }

    @Override
    @Nullable
    public final RpcRequest rpcRequest() {
        return this.rpcReq;
    }

    @Override
    public final void updateRequest(HttpRequest req) {
        Objects.requireNonNull(req, "req");
        RequestHeaders headers = req.headers();
        RequestTarget reqTarget = this.validateHeaders(headers);
        if (reqTarget == null) {
            throw new IllegalArgumentException("invalid path: " + headers.path());
        }
        if (reqTarget.form() == RequestTargetForm.ABSOLUTE) {
            throw new IllegalArgumentException("invalid path: " + headers.path() + " (must not contain scheme or authority)");
        }
        this.req = req;
        this.reqTarget = reqTarget;
        this.decodedPath = null;
    }

    @Override
    public final void updateRpcRequest(RpcRequest rpcReq) {
        Objects.requireNonNull(rpcReq, "rpcReq");
        this.rpcReq = rpcReq;
    }

    @Nullable
    protected abstract RequestTarget validateHeaders(RequestHeaders var1);

    @Nullable
    protected abstract Channel channel();

    @Override
    public final RequestId id() {
        return this.id;
    }

    @Override
    public final HttpMethod method() {
        return this.method;
    }

    @Override
    public final String path() {
        return this.reqTarget.path();
    }

    protected final RequestTarget requestTarget() {
        return this.reqTarget;
    }

    @Override
    public final String decodedPath() {
        String decodedPath = this.decodedPath;
        if (decodedPath != null) {
            return decodedPath;
        }
        this.decodedPath = ArmeriaHttpUtil.decodePath(this.path());
        return this.decodedPath;
    }

    @Override
    @Nullable
    public final String query() {
        return this.reqTarget.query();
    }

    @Override
    public ExchangeType exchangeType() {
        return this.exchangeType;
    }

    @Override
    public final MeterRegistry meterRegistry() {
        return this.meterRegistry;
    }

    @Override
    public long requestAutoAbortDelayMillis() {
        return this.requestAutoAbortDelayMillis;
    }

    @Override
    public void setRequestAutoAbortDelayMillis(long delayMillis) {
        this.requestAutoAbortDelayMillis = delayMillis;
    }

    @Override
    @Nullable
    public <V> V attr(AttributeKey<V> key) {
        Objects.requireNonNull(key, "key");
        return this.attrs.attr(key);
    }

    @Override
    @Nullable
    public final <V> V ownAttr(AttributeKey<V> key) {
        Objects.requireNonNull(key, "key");
        return this.attrs.ownAttr(key);
    }

    @Override
    @Nullable
    public final <V> V setAttr(AttributeKey<V> key, @Nullable V value) {
        Objects.requireNonNull(key, "key");
        return this.attrs.getAndSet(key, value);
    }

    @Override
    public Iterator<Map.Entry<AttributeKey<?>, Object>> attrs() {
        return this.attrs.attrs();
    }

    @Override
    public final Iterator<Map.Entry<AttributeKey<?>, Object>> ownAttrs() {
        return this.attrs.ownAttrs();
    }

    @Override
    @UnstableApi
    public final AttributesGetters attributes() {
        return this.attrs;
    }

    @Override
    public Request originalRequest() {
        return this.originalRequest;
    }

    @Override
    @UnstableApi
    public void hook(Supplier<? extends AutoCloseable> contextHook) {
        Supplier<AutoCloseable> newContextHook;
        Supplier<AutoCloseable> oldContextHook;
        Objects.requireNonNull(contextHook, "contextHook");
        if (contextHook == RequestContextUtil.NOOP_CONTEXT_HOOK) {
            return;
        }
        while (!contextHookUpdater.compareAndSet(this, oldContextHook = this.contextHook, newContextHook = RequestContextUtil.mergeHooks(oldContextHook, contextHook))) {
        }
    }

    @Override
    public Supplier<AutoCloseable> hook() {
        return this.contextHook;
    }
}

