/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.common;

import io.opentelemetry.testing.internal.armeria.common.JacksonObjectMapperProvider;
import io.opentelemetry.testing.internal.jackson.databind.DeserializationFeature;
import io.opentelemetry.testing.internal.jackson.databind.ObjectMapper;
import io.opentelemetry.testing.internal.jackson.databind.json.JsonMapper;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

enum DefaultJacksonObjectMapperProvider implements JacksonObjectMapperProvider
{
    INSTANCE;

    private static final Logger logger;
    private static boolean noticed;

    @Override
    public ObjectMapper newObjectMapper() {
        JsonMapper.Builder jsonMapperBuilder = JsonMapper.builder();
        jsonMapperBuilder.findAndAddModules();
        Object mapper = jsonMapperBuilder.build();
        Set<Object> registeredModuleIds = ((ObjectMapper)mapper).getRegisteredModuleIds();
        if (registeredModuleIds.contains("io.opentelemetry.testing.internal.jackson.module.scala.DefaultScalaModule")) {
            ((ObjectMapper)mapper).enable(DeserializationFeature.FAIL_ON_NULL_CREATOR_PROPERTIES);
        }
        if (!noticed) {
            if (!registeredModuleIds.isEmpty()) {
                logger.debug("Available Jackson Modules: {}", registeredModuleIds);
            }
            noticed = true;
        }
        return mapper;
    }

    static {
        logger = LoggerFactory.getLogger(DefaultJacksonObjectMapperProvider.class);
    }
}

