/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.client;

import io.opentelemetry.testing.internal.armeria.client.Client;
import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.HttpClient;
import io.opentelemetry.testing.internal.armeria.client.HttpPreClient;
import io.opentelemetry.testing.internal.armeria.client.PreClient;
import io.opentelemetry.testing.internal.armeria.client.PreClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.RpcClient;
import io.opentelemetry.testing.internal.armeria.client.RpcPreClient;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.Request;
import io.opentelemetry.testing.internal.armeria.common.Response;
import io.opentelemetry.testing.internal.armeria.common.RpcResponse;
import io.opentelemetry.testing.internal.armeria.internal.client.ClientRequestContextExtension;
import io.opentelemetry.testing.internal.armeria.internal.client.ClientUtil;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class TailPreClient<I extends Request, O extends Response, C extends Client<I, O>>
implements PreClient<I, O> {
    private final C delegate;
    private final Function<CompletableFuture<O>, O> futureConverter;
    private final BiFunction<ClientRequestContext, Throwable, O> errorResponseFactory;
    private final BiFunction<ClientRequestContextExtension, C, C> clientCustomizer;

    private TailPreClient(C delegate, Function<CompletableFuture<O>, O> futureConverter, BiFunction<ClientRequestContext, Throwable, O> errorResponseFactory, BiFunction<ClientRequestContextExtension, C, C> clientCustomizer) {
        this.delegate = delegate;
        this.futureConverter = futureConverter;
        this.errorResponseFactory = errorResponseFactory;
        this.clientCustomizer = clientCustomizer;
    }

    public static HttpPreClient of(HttpClient httpClient, Function<CompletableFuture<HttpResponse>, HttpResponse> futureConverter, BiFunction<ClientRequestContext, Throwable, HttpResponse> errorResponseFactory) {
        TailPreClient tail = new TailPreClient(httpClient, futureConverter, errorResponseFactory, (ctx, delegate) -> ctx.httpClientCustomizer().apply((HttpClient)delegate));
        return tail::execute;
    }

    public static RpcPreClient ofRpc(RpcClient rpcClient, Function<CompletableFuture<RpcResponse>, RpcResponse> futureConverter, BiFunction<ClientRequestContext, Throwable, RpcResponse> errorResponseFactory) {
        TailPreClient tail = new TailPreClient(rpcClient, futureConverter, errorResponseFactory, (ctx, delegate) -> ctx.rpcClientCustomizer().apply((RpcClient)delegate));
        return tail::execute;
    }

    @Override
    public O execute(PreClientRequestContext ctx, I req) {
        ClientRequestContextExtension ctxExt = ctx.as(ClientRequestContextExtension.class);
        assert (ctxExt != null);
        Client delegate0 = (Client)this.clientCustomizer.apply(ctxExt, this.delegate);
        return ClientUtil.initContextAndExecuteWithFallback(delegate0, ctxExt, this.futureConverter, this.errorResponseFactory, req, true);
    }
}

