/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.client;

import io.opentelemetry.testing.internal.armeria.client.Client;
import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.PreClient;
import io.opentelemetry.testing.internal.armeria.client.PreClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.UnprocessedRequestException;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointGroup;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.Request;
import io.opentelemetry.testing.internal.armeria.common.RequestId;
import io.opentelemetry.testing.internal.armeria.common.Response;
import io.opentelemetry.testing.internal.armeria.common.ResponseCompleteException;
import io.opentelemetry.testing.internal.armeria.common.RpcRequest;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.logging.RequestLog;
import io.opentelemetry.testing.internal.armeria.common.logging.RequestLogAccess;
import io.opentelemetry.testing.internal.armeria.common.logging.RequestLogBuilder;
import io.opentelemetry.testing.internal.armeria.common.logging.RequestLogProperty;
import io.opentelemetry.testing.internal.armeria.common.stream.StreamMessage;
import io.opentelemetry.testing.internal.armeria.common.util.Exceptions;
import io.opentelemetry.testing.internal.armeria.common.util.SafeCloseable;
import io.opentelemetry.testing.internal.armeria.internal.client.ClientRequestContextExtension;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class ClientUtil {
    public static final URI UNDEFINED_URI = URI.create("http://armeria-undefined:1");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <I extends Request, O extends Response, U extends Client<I, O>> O initContextAndExecuteWithFallback(U delegate, ClientRequestContextExtension ctx, Function<CompletableFuture<O>, O> futureConverter, BiFunction<ClientRequestContext, Throwable, O> errorResponseFactory, I req, boolean tryCompleteLog) {
        Response response;
        block10: {
            Objects.requireNonNull(delegate, "delegate");
            Objects.requireNonNull(ctx, "ctx");
            Objects.requireNonNull(futureConverter, "futureConverter");
            Objects.requireNonNull(errorResponseFactory, "errorResponseFactory");
            boolean initialized = false;
            boolean success = false;
            try {
                CompletableFuture<Boolean> initFuture = ctx.init();
                initialized = initFuture.isDone();
                if (initialized) {
                    try {
                        success = initFuture.get();
                    }
                    catch (Exception e) {
                        throw UnprocessedRequestException.of(Exceptions.peel(e));
                    }
                    response = ClientUtil.initContextAndExecuteWithFallback(delegate, ctx, errorResponseFactory, success, req);
                    break block10;
                }
                response = (Response)futureConverter.apply((CompletableFuture<O>)initFuture.handle((success0, cause) -> {
                    try {
                        if (cause != null) {
                            throw UnprocessedRequestException.of(Exceptions.peel(cause));
                        }
                        Object o = ClientUtil.initContextAndExecuteWithFallback(delegate, ctx, errorResponseFactory, success0, req);
                        return o;
                    }
                    catch (Throwable t) {
                        ClientUtil.fail(ctx, t);
                        Response response = (Response)errorResponseFactory.apply(ctx, t);
                        return response;
                    }
                    finally {
                        ctx.finishInitialization((boolean)success0);
                    }
                }));
            }
            catch (Throwable cause2) {
                ClientUtil.fail(ctx, cause2);
                response = (Response)errorResponseFactory.apply(ctx, cause2);
            }
            finally {
                if (initialized) {
                    ctx.finishInitialization(success);
                }
            }
        }
        if (tryCompleteLog) {
            ClientUtil.completeLogIfIncomplete(ctx, response);
        }
        return (O)response;
    }

    private static <I extends Request, O extends Response, U extends Client<I, O>> O initContextAndExecuteWithFallback(U delegate, ClientRequestContextExtension ctx, BiFunction<ClientRequestContext, Throwable, O> errorResponseFactory, boolean succeeded, I req) throws Exception {
        if (succeeded) {
            return ClientUtil.pushAndExecute(delegate, ctx, req);
        }
        Throwable cause = ctx.log().partial().requestCause();
        assert (cause != null);
        O res = ClientUtil.pushAndExecute(delegate, ctx, req);
        if (res instanceof StreamMessage) {
            ((StreamMessage)res).abort(cause);
        }
        return (O)((Response)errorResponseFactory.apply(ctx, cause));
    }

    public static <I extends Request, O extends Response, U extends Client<I, O>> O executeWithFallback(U delegate, ClientRequestContext ctx, BiFunction<ClientRequestContext, Throwable, O> errorResponseFactory, I req, boolean tryCompleteLog) {
        Object response;
        Objects.requireNonNull(delegate, "delegate");
        Objects.requireNonNull(ctx, "ctx");
        Objects.requireNonNull(errorResponseFactory, "errorResponseFactory");
        try {
            response = ClientUtil.pushAndExecute(delegate, ctx, req);
        }
        catch (Throwable cause) {
            ClientUtil.fail(ctx, cause);
            response = (Response)errorResponseFactory.apply(ctx, cause);
        }
        if (tryCompleteLog) {
            ClientUtil.completeLogIfIncomplete(ctx, response);
        }
        return response;
    }

    public static <I extends Request, O extends Response, U extends PreClient<I, O>> O executeWithFallback(U execution, PreClientRequestContext ctx, I req, BiFunction<ClientRequestContext, Throwable, O> errorResponseFactory) {
        ClientRequestContextExtension ctxExt = ctx.as(ClientRequestContextExtension.class);
        if (ctxExt != null) {
            ctxExt.runContextCustomizer();
        }
        try {
            return execution.execute(ctx, req);
        }
        catch (Exception e) {
            ClientUtil.fail(ctx, e);
            return (O)((Response)errorResponseFactory.apply(ctx, e));
        }
    }

    private static <I extends Request, O extends Response, U extends Client<I, O>> O pushAndExecute(U delegate, ClientRequestContext ctx, I req) throws Exception {
        try (SafeCloseable ignored = ctx.push();){
            O o = delegate.execute(ctx, req);
            return o;
        }
    }

    private static <O extends Response> void completeLogIfIncomplete(ClientRequestContext ctx, O response) {
        response.whenComplete().handle((unused, cause) -> {
            RequestLogBuilder logBuilder = ctx.logBuilder();
            if (!logBuilder.isAvailable(RequestLogProperty.REQUEST_FIRST_BYTES_TRANSFERRED_TIME)) {
                if (cause != null) {
                    ctx.cancel((Throwable)cause);
                } else {
                    ctx.cancel(ResponseCompleteException.get());
                }
            }
            return null;
        });
    }

    private static void fail(ClientRequestContext ctx, Throwable cause) {
        HttpRequest req = ctx.request();
        if (req != null) {
            req.abort(cause);
        }
        RequestLogBuilder logBuilder = ctx.logBuilder();
        logBuilder.endRequest(cause);
        logBuilder.endResponse(cause);
    }

    public static ClientRequestContext newDerivedContext(ClientRequestContext ctx, @Nullable HttpRequest req, @Nullable RpcRequest rpcReq, boolean initialAttempt) {
        RequestLogBuilder parentLogBuilder;
        RequestId id = ctx.options().requestIdGenerator().get();
        EndpointGroup endpointGroup = ctx.endpointGroup();
        ClientRequestContext derived = endpointGroup != null && !initialAttempt ? ctx.newDerivedContext(id, req, rpcReq, endpointGroup.selectNow(ctx)) : ctx.newDerivedContext(id, req, rpcReq, ctx.endpoint());
        RequestLogAccess parentLog = ctx.log();
        RequestLog partial = parentLog.partial();
        RequestLogBuilder logBuilder = derived.logBuilder();
        logBuilder.serializationFormat(partial.serializationFormat());
        if (parentLog.isAvailable(RequestLogProperty.NAME)) {
            String serviceName = partial.serviceName();
            String name = partial.name();
            if (serviceName != null) {
                logBuilder.name(serviceName, name);
            } else {
                logBuilder.name(name);
            }
        }
        if ((parentLogBuilder = ctx.logBuilder()).isDeferred(RequestLogProperty.REQUEST_CONTENT)) {
            logBuilder.defer(RequestLogProperty.REQUEST_CONTENT);
        }
        parentLog.whenAvailable(RequestLogProperty.REQUEST_CONTENT).thenAccept(requestLog -> logBuilder.requestContent(requestLog.requestContent(), requestLog.rawRequestContent()));
        if (parentLogBuilder.isDeferred(RequestLogProperty.REQUEST_CONTENT_PREVIEW)) {
            logBuilder.defer(RequestLogProperty.REQUEST_CONTENT_PREVIEW);
        }
        parentLog.whenAvailable(RequestLogProperty.REQUEST_CONTENT_PREVIEW).thenAccept(requestLog -> logBuilder.requestContentPreview(requestLog.requestContentPreview()));
        if (parentLogBuilder.isDeferred(RequestLogProperty.RESPONSE_CONTENT)) {
            logBuilder.defer(RequestLogProperty.RESPONSE_CONTENT);
            parentLog.whenAvailable(RequestLogProperty.RESPONSE_CONTENT).thenAccept(requestLog -> logBuilder.responseContent(requestLog.responseContent(), requestLog.rawResponseContent()));
        }
        if (parentLogBuilder.isDeferred(RequestLogProperty.RESPONSE_CONTENT_PREVIEW)) {
            logBuilder.defer(RequestLogProperty.RESPONSE_CONTENT_PREVIEW);
            parentLog.whenAvailable(RequestLogProperty.RESPONSE_CONTENT_PREVIEW).thenAccept(requestLog -> logBuilder.responseContentPreview(requestLog.responseContentPreview()));
        }
        ctx.logBuilder().addChild(derived.log());
        return derived;
    }

    private ClientUtil() {
    }
}

