/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.websocket;

import io.opentelemetry.testing.internal.armeria.common.stream.DefaultStreamMessage;
import io.opentelemetry.testing.internal.armeria.common.websocket.CloseWebSocketFrame;
import io.opentelemetry.testing.internal.armeria.common.websocket.WebSocketCloseStatus;
import io.opentelemetry.testing.internal.armeria.common.websocket.WebSocketFrame;
import io.opentelemetry.testing.internal.armeria.common.websocket.WebSocketFrameType;
import io.opentelemetry.testing.internal.armeria.common.websocket.WebSocketWriter;

final class DefaultWebSocket
extends DefaultStreamMessage<WebSocketFrame>
implements WebSocketWriter {
    DefaultWebSocket() {
    }

    @Override
    public boolean tryWrite(WebSocketFrame obj) {
        boolean written = super.tryWrite(obj);
        if (written && obj.type() == WebSocketFrameType.CLOSE) {
            super.close();
        }
        return written;
    }

    @Override
    public void close() {
        this.close(WebSocketCloseStatus.NORMAL_CLOSURE);
    }

    @Override
    public void close(WebSocketCloseStatus status) {
        this.close(WebSocketFrame.ofClose(status));
    }

    @Override
    public void close(WebSocketCloseStatus status, String reasonPhrase) {
        this.close(WebSocketFrame.ofClose(status, reasonPhrase));
    }

    private void close(CloseWebSocketFrame closeFrame) {
        boolean ignored = this.tryWrite(closeFrame);
    }
}

