/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.util;

import io.opentelemetry.testing.internal.armeria.common.Flags;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.util.Exceptions;
import io.opentelemetry.testing.internal.armeria.common.util.OsType;
import io.opentelemetry.testing.internal.armeria.internal.common.JavaVersionSpecific;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Ascii;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.io.netty.util.NetUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.IDN;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemInfo {
    private static final Logger logger = LoggerFactory.getLogger(SystemInfo.class);
    private static final int JAVA_VERSION;
    private static final boolean JETTY_ALPN_OPTIONAL_OR_AVAILABLE;
    private static final OsType osType;

    public static int javaVersion() {
        return JAVA_VERSION;
    }

    public static String hostname() {
        return Hostname.HOSTNAME;
    }

    public static boolean jettyAlpnOptionalOrAvailable() {
        return JETTY_ALPN_OPTIONAL_OR_AVAILABLE;
    }

    public static int pid() {
        if (Pid.PID <= 0) {
            throw new IllegalStateException("Failed to retrieve the current PID.");
        }
        return Pid.PID;
    }

    public static boolean hasIpV6() {
        return HasIpV6.HAS_IPV6;
    }

    @Nullable
    public static Inet4Address defaultNonLoopbackIpV4Address() {
        return DefaultNonLoopbackIPv4Address.defaultNonLoopbackIpV4Address;
    }

    public static long currentTimeMicros() {
        return JavaVersionSpecific.get().currentTimeMicros();
    }

    public static OsType osType() {
        return osType;
    }

    public static boolean isLinux() {
        return osType == OsType.LINUX;
    }

    private SystemInfo() {
    }

    static {
        int javaVersion = -1;
        try {
            String spec = System.getProperty("java.specification.version");
            if (spec != null) {
                int minor;
                int major;
                String[] strValues = spec.split("\\.");
                switch (strValues.length) {
                    case 0: {
                        major = 0;
                        minor = 0;
                        break;
                    }
                    case 1: {
                        major = Integer.parseInt(strValues[0]);
                        minor = 0;
                        break;
                    }
                    default: {
                        major = Integer.parseInt(strValues[0]);
                        minor = Integer.parseInt(strValues[1]);
                    }
                }
                if (major > 1) {
                    javaVersion = major;
                } else if (major == 1) {
                    if (minor == 0) {
                        javaVersion = 1;
                    } else if (minor > 0) {
                        javaVersion = minor;
                    }
                }
            }
            if (javaVersion > 0) {
                logger.debug("Java version: {}", (Object)javaVersion);
            } else {
                logger.warn("'java.specification.version' contains an unexpected value: {}", (Object)spec);
            }
        }
        catch (Throwable t) {
            logger.warn("Failed to determine Java version", t);
        }
        int n = JAVA_VERSION = javaVersion > 0 ? javaVersion : 8;
        if (JAVA_VERSION >= 9) {
            JETTY_ALPN_OPTIONAL_OR_AVAILABLE = true;
        } else {
            boolean temp;
            try {
                Class.forName("sun.security.ssl.ALPNExtension", true, null);
                temp = true;
            }
            catch (Throwable ignore) {
                temp = false;
            }
            JETTY_ALPN_OPTIONAL_OR_AVAILABLE = temp;
        }
        String osName = Ascii.toUpperCase(System.getProperty("os.name", ""));
        osType = osName.startsWith("WINDOWS") ? OsType.WINDOWS : (osName.startsWith("LINUX") ? OsType.LINUX : (osName.startsWith("MAC") ? OsType.MAC : OsType.OTHERS));
    }

    private static final class Hostname {
        private static final Pattern HOSTNAME_PATTERN = Pattern.compile("^(?:[-_a-zA-Z0-9]|[-_a-zA-Z0-9][-_.a-zA-Z0-9]*[-_a-zA-Z0-9])$");
        static final String HOSTNAME;

        private Hostname() {
        }

        @Nullable
        private static String normalizeHostname(String line) {
            String hostname = IDN.toASCII(line.trim(), 1);
            if (!HOSTNAME_PATTERN.matcher(hostname).matches()) {
                return null;
            }
            return Ascii.toLowerCase(hostname);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static {
            String hostname = null;
            if (SystemInfo.isLinux()) {
                try {
                    List<String> lines = Files.readAllLines(Paths.get("/proc/sys/kernel/hostname", new String[0]));
                    if (!lines.isEmpty()) {
                        hostname = Hostname.normalizeHostname(lines.get(0));
                    }
                    if (hostname != null) {
                        logger.info("hostname: {} (from /proc/sys/kernel/hostname)", (Object)hostname);
                    } else {
                        logger.debug("/proc/sys/kernel/hostname does not contain a valid hostname: {}", lines);
                    }
                }
                catch (Throwable t) {
                    logger.debug("Failed to get the hostname from /proc/sys/kernel/hostname; using the 'hostname' command instead", t);
                }
            }
            if (hostname == null) {
                Process process = null;
                try {
                    process = Runtime.getRuntime().exec("hostname");
                    BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String line = in.readLine();
                    if (line != null) {
                        hostname = Hostname.normalizeHostname(line);
                    }
                    if (hostname != null) {
                        logger.info("hostname: {} (from 'hostname' command)", (Object)hostname);
                    } else {
                        logger.debug("The 'hostname' command returned a non-hostname ({}); using InetAddress.getLocalHost() instead", (Object)line);
                    }
                }
                catch (Throwable t) {
                    logger.debug("Failed to get the hostname using the 'hostname' command; using InetAddress.getLocalHost() instead", t);
                }
                finally {
                    if (process != null) {
                        process.destroy();
                    }
                }
            }
            if (hostname == null) {
                try {
                    String jdkHostname = InetAddress.getLocalHost().getHostName();
                    hostname = Hostname.normalizeHostname(jdkHostname);
                    if (hostname == null) {
                        logger.warn("InetAddress.getLocalHost() returned an invalid hostname ({}); using 'localhost' instead", (Object)jdkHostname);
                    } else {
                        logger.info("hostname: {} (from InetAddress.getLocalHost())", (Object)hostname);
                    }
                }
                catch (Throwable t) {
                    logger.warn("Failed to get the hostname using InetAddress.getLocalHost(); using 'localhost' instead", t);
                }
            }
            HOSTNAME = MoreObjects.firstNonNull(hostname, "localhost");
        }
    }

    private static final class Pid {
        static final int PID;

        private Pid() {
        }

        private static int validatePid(@Nullable Object value) {
            if (!(value instanceof Number)) {
                return -1;
            }
            int pid = ((Number)value).intValue();
            return pid > 0 ? pid : -1;
        }

        private static void logFailure(String method, boolean warn, Throwable cause) {
            if ((cause = Exceptions.peel(cause)) instanceof UnsupportedOperationException || cause instanceof SecurityException || cause instanceof IllegalAccessException) {
                logger.debug("An access to {} not possible due to platform restriction:", (Object)method, (Object)cause);
                return;
            }
            String msg = "Failed to retrieve the current PID from {}:";
            if (warn) {
                logger.warn("Failed to retrieve the current PID from {}:", (Object)method, (Object)cause);
            } else {
                logger.debug("Failed to retrieve the current PID from {}:", (Object)method, (Object)cause);
            }
        }

        static {
            Object result;
            int pid = -1;
            if (SystemInfo.javaVersion() >= 9) {
                try {
                    Class<?> handleClass = Class.forName("java.lang.ProcessHandle", true, Process.class.getClassLoader());
                    Method currentMethod = handleClass.getDeclaredMethod("current", new Class[0]);
                    Method pidMethod = handleClass.getDeclaredMethod("pid", new Class[0]);
                    Object currentHandle = currentMethod.invoke(null, new Object[0]);
                    result = pidMethod.invoke(currentHandle, new Object[0]);
                    pid = Pid.validatePid(result);
                    if (pid <= 0) {
                        logger.warn("ProcessHandle.pid() returned an invalid PID: {}", result);
                    } else {
                        logger.info("PID: {} (from ProcessHandle.pid())", (Object)pid);
                    }
                }
                catch (Throwable t) {
                    Pid.logFailure("ProcessHandle.current()", true, t);
                }
            }
            if (pid <= 0) {
                try {
                    RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
                    Field jvmField = runtime.getClass().getDeclaredField("jvm");
                    jvmField.setAccessible(true);
                    Object jvm = jvmField.get(runtime);
                    Method getProcessIdMethod = jvm.getClass().getDeclaredMethod("getProcessId", new Class[0]);
                    getProcessIdMethod.setAccessible(true);
                    result = getProcessIdMethod.invoke(jvm, new Object[0]);
                    pid = Pid.validatePid(result);
                    if (pid <= 0) {
                        logger.warn("VMManagement.getProcessId() returned an invalid PID: {}", result);
                    } else {
                        logger.info("PID: {} (from VMManagement.getProcessId())", (Object)pid);
                    }
                }
                catch (Throwable t) {
                    Pid.logFailure("VMManagement.getProcessId()", false, t);
                }
            }
            if (pid <= 0 && SystemInfo.isLinux()) {
                try {
                    Path path = Paths.get("/proc/self", new String[0]);
                    if (Files.isSymbolicLink(path)) {
                        Path realPath = path.toRealPath(new LinkOption[0]);
                        pid = Pid.validatePid(Integer.parseInt(realPath.getFileName().toString()));
                        if (pid <= 0) {
                            logger.warn("/proc/self does not refer to a PID-named file: {}", (Object)realPath);
                        } else {
                            logger.info("PID: {} (from /proc/self)", (Object)pid);
                        }
                    }
                }
                catch (Throwable t) {
                    Pid.logFailure("/proc/self", false, t);
                }
            }
            if (pid <= 0) {
                try {
                    String result2 = ManagementFactory.getRuntimeMXBean().getName();
                    String[] values = result2.split("@");
                    pid = Pid.validatePid(values.length > 0 ? Integer.parseInt(values[0]) : -1);
                    if (pid <= 0) {
                        logger.warn("RuntimeMXBean.getName() returned an unexpected value: {}", (Object)result2);
                    } else {
                        logger.info("PID: {} (from RuntimeMXBean.getName())", (Object)pid);
                    }
                }
                catch (Throwable t) {
                    Pid.logFailure("RuntimeMXBean.getName()", true, t);
                }
            }
            PID = pid;
        }
    }

    private static final class HasIpV6 {
        static final boolean HAS_IPV6;

        private HasIpV6() {
        }

        private static boolean hasNoIpV6NetworkInterface() {
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                while (interfaces.hasMoreElements()) {
                    NetworkInterface iface = interfaces.nextElement();
                    Enumeration<InetAddress> addresses = iface.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        InetAddress inetAddress = addresses.nextElement();
                        if (!(inetAddress instanceof Inet6Address) || inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress()) continue;
                        return false;
                    }
                }
            }
            catch (SocketException e) {
                logger.debug("Unable to detect if the machine has an IPv6 network interface", (Throwable)e);
                return false;
            }
            return true;
        }

        static {
            boolean hasIpV6 = true;
            if (NetUtil.isIpV4StackPreferred()) {
                hasIpV6 = false;
                logger.info("IPv6: disabled (java.net.preferIPv4Stack=true)");
            } else if (SystemInfo.isLinux()) {
                String sysfsPath = "/proc/sys/net/ipv6/conf/all/disable_ipv6";
                try {
                    List<String> lines = Files.readAllLines(Paths.get("/proc/sys/net/ipv6/conf/all/disable_ipv6", new String[0]));
                    if (!lines.isEmpty() && !"0".equals(lines.get(0))) {
                        hasIpV6 = false;
                        logger.info("IPv6: disabled (from {})", (Object)"/proc/sys/net/ipv6/conf/all/disable_ipv6");
                    }
                }
                catch (Throwable t) {
                    logger.debug("Failed to read {}", (Object)"/proc/sys/net/ipv6/conf/all/disable_ipv6", (Object)t);
                }
            }
            if (hasIpV6 && HasIpV6.hasNoIpV6NetworkInterface()) {
                hasIpV6 = false;
                logger.info("IPv6: disabled (no IPv6 network interface)");
            }
            if (hasIpV6) {
                try (ServerSocket ss = new ServerSocket();){
                    ss.bind(new InetSocketAddress(NetUtil.LOCALHOST6, 0));
                }
                catch (IOException ignored) {
                    hasIpV6 = false;
                    logger.info("IPv6: disabled (unable to listen on ::1)");
                }
            }
            HAS_IPV6 = hasIpV6;
        }
    }

    private static final class DefaultNonLoopbackIPv4Address {
        @Nullable
        static final Inet4Address defaultNonLoopbackIpV4Address;

        private DefaultNonLoopbackIPv4Address() {
        }

        private static boolean isPreferredAddress(InetAddress address) {
            Predicate<InetAddress> predicates = Flags.preferredIpV4Addresses();
            return predicates.test(address);
        }

        static {
            Inet4Address result = null;
            String nicDisplayName = null;
            try {
                int lowest = Integer.MAX_VALUE;
                Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
                while (nics.hasMoreElements()) {
                    NetworkInterface nic = nics.nextElement();
                    if (!nic.isUp()) {
                        logger.debug("{} is down. Trying next.", (Object)nic.getDisplayName());
                        continue;
                    }
                    if (nic.getIndex() >= lowest && result != null) {
                        logger.debug("{} has higher index({}) than {}. Skip.", new Object[]{nic.getDisplayName(), nic.getIndex(), result});
                        continue;
                    }
                    lowest = nic.getIndex();
                    Enumeration<InetAddress> addrs = nic.getInetAddresses();
                    while (addrs.hasMoreElements()) {
                        InetAddress address = addrs.nextElement();
                        if (!(address instanceof Inet4Address)) {
                            logger.debug("{} of {} is not an Inet4Address. Trying next.", (Object)address, (Object)nic.getDisplayName());
                            continue;
                        }
                        if (address.isLoopbackAddress()) {
                            logger.debug("{} of {} is a loopback address. Trying next.", (Object)address, (Object)nic.getDisplayName());
                            continue;
                        }
                        if (!DefaultNonLoopbackIPv4Address.isPreferredAddress(address)) {
                            logger.debug("{} of {} is not a preferred IP address. Trying next.", (Object)address, (Object)nic.getDisplayName());
                            continue;
                        }
                        result = (Inet4Address)address;
                        nicDisplayName = nic.getDisplayName();
                    }
                }
            }
            catch (IOException ex) {
                logger.warn("Could not get a non-loopback IPv4 address:", (Throwable)ex);
            }
            if (result != null) {
                defaultNonLoopbackIpV4Address = result;
                logger.info("defaultNonLoopbackIpV4Address: {} (from: {})", (Object)defaultNonLoopbackIpV4Address, nicDisplayName);
            } else {
                Inet4Address temp = null;
                try {
                    InetAddress localHost = InetAddress.getLocalHost();
                    if (localHost instanceof Inet4Address) {
                        temp = (Inet4Address)localHost;
                        logger.info("defaultNonLoopbackIpV4Address: {} (from: InetAddress.getLocalHost())", (Object)temp);
                    } else {
                        logger.warn("Could not get a non-loopback IPv4 address. defaultNonLoopbackIpV4Address is set to null.");
                    }
                }
                catch (UnknownHostException e) {
                    logger.warn("Unable to retrieve the localhost address. defaultNonLoopbackIpV4Address is set to null.", (Throwable)e);
                }
                defaultNonLoopbackIpV4Address = temp;
            }
        }
    }
}

