/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.util;

import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Objects;
import java.util.function.Predicate;

final class Inet6AddressBlock
implements Predicate<InetAddress> {
    private final Inet6Address baseAddress;
    private final int maskBits;
    private final long[] lowerBound;
    private final long[] upperBound;
    private final boolean[] skipCompare = new boolean[2];

    Inet6AddressBlock(Inet6Address baseAddress, int maskBits) {
        this.baseAddress = Objects.requireNonNull(baseAddress, "baseAddress");
        Preconditions.checkArgument(maskBits >= 0 && maskBits <= 128, "maskBits: %s (expected: 0-128)", maskBits);
        this.maskBits = maskBits;
        if (maskBits == 128) {
            this.upperBound = Inet6AddressBlock.ipv6AddressToLongArray(baseAddress);
            this.lowerBound = this.upperBound;
        } else if (maskBits == 0) {
            this.upperBound = new long[]{0L, 0L};
            this.lowerBound = this.upperBound;
        } else {
            long[] mask = Inet6AddressBlock.calculateMask(maskBits);
            this.lowerBound = Inet6AddressBlock.calculateLowerBound(baseAddress, mask);
            this.upperBound = Inet6AddressBlock.calculateUpperBound(this.lowerBound, mask);
            this.skipCompare[0] = this.lowerBound[0] == 0L && this.upperBound[0] == -1L;
            this.skipCompare[1] = this.lowerBound[1] == 0L && this.upperBound[1] == -1L;
        }
    }

    @Override
    public boolean test(InetAddress address) {
        Objects.requireNonNull(address, "address");
        if (address instanceof Inet4Address) {
            return false;
        }
        if (address instanceof Inet6Address) {
            if (this.maskBits == 0) {
                return true;
            }
            long[] value = Inet6AddressBlock.ipv6AddressToLongArray((Inet6Address)address);
            return (this.skipCompare[0] || value[0] >= this.lowerBound[0] && value[0] <= this.upperBound[0]) && (this.skipCompare[1] || value[1] >= this.lowerBound[1] && value[1] <= this.upperBound[1]);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("baseAddress", this.baseAddress).add("maskBits", this.maskBits).add("lowerBound", "0x" + Long.toHexString(this.lowerBound[0]) + ':' + Long.toHexString(this.lowerBound[1])).add("upperBound", "0x" + Long.toHexString(this.upperBound[0]) + ':' + Long.toHexString(this.upperBound[1])).toString();
    }

    private static long[] ipv6AddressToLongArray(Inet6Address address) {
        long[] values = new long[2];
        byte[] bytes = address.getAddress();
        assert (bytes.length == 16);
        for (int i = 0; i < bytes.length; ++i) {
            int index;
            int n = index = i / 8;
            values[n] = values[n] << 8;
            int n2 = index;
            values[n2] = values[n2] | (long)(bytes[i] & 0xFF);
        }
        return values;
    }

    private static long[] calculateLowerBound(Inet6Address baseAddress, long[] mask) {
        long[] values = Inet6AddressBlock.ipv6AddressToLongArray(baseAddress);
        if (mask[0] > 0L) {
            values[0] = values[0] & -mask[0];
            values[1] = 0L;
        } else {
            values[1] = values[1] & -mask[1];
        }
        return values;
    }

    private static long[] calculateUpperBound(long[] lowerBound, long[] mask) {
        long[] values = new long[2];
        if (mask[0] > 0L) {
            values[0] = lowerBound[0] + mask[0] - 1L;
            values[1] = -1L;
        } else {
            values[0] = lowerBound[0];
            values[1] = lowerBound[1] + mask[1] - 1L;
        }
        return values;
    }

    private static long[] calculateMask(int maskBits) {
        long[] mask = new long[2];
        int shift = 128 - maskBits;
        if (shift < 64) {
            mask[1] = 1L << shift;
        } else {
            mask[0] = 1L << (int)((long)shift - 64L);
        }
        return mask;
    }
}

