/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.util;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.common.util.EventCount;
import io.opentelemetry.testing.internal.armeria.common.util.SlidingWindowCounter;
import io.opentelemetry.testing.internal.armeria.common.util.Ticker;
import java.time.Duration;
import java.util.Objects;

@UnstableApi
public interface EventCounter {
    public static EventCounter ofSlidingWindow(Ticker ticker, Duration slidingWindow, Duration updateInterval) {
        Objects.requireNonNull(ticker, "ticker");
        Objects.requireNonNull(slidingWindow, "slidingWindow");
        Objects.requireNonNull(updateInterval, "updateInterval");
        return new SlidingWindowCounter(ticker, slidingWindow, updateInterval);
    }

    public static EventCounter ofSlidingWindow(Duration slidingWindow, Duration updateInterval) {
        return EventCounter.ofSlidingWindow(Ticker.systemTicker(), slidingWindow, updateInterval);
    }

    public EventCount count();

    @Nullable
    public EventCount onSuccess();

    @Nullable
    public EventCount onFailure();
}

