/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.outlier;

import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.common.outlier.OutlierDetectingRuleBuilder;
import io.opentelemetry.testing.internal.armeria.common.outlier.OutlierDetectionDecision;
import java.util.Objects;

@FunctionalInterface
@UnstableApi
public interface OutlierRule {
    public static OutlierRule of() {
        return OutlierDetectingRuleBuilder.DEFAULT_RULE;
    }

    public static OutlierDetectingRuleBuilder builder() {
        return new OutlierDetectingRuleBuilder();
    }

    public OutlierDetectionDecision decide(RequestContext var1, @Nullable ResponseHeaders var2, @Nullable Throwable var3);

    default public OutlierRule orElse(OutlierRule other) {
        Objects.requireNonNull(other, "other");
        return (ctx, headers, cause) -> {
            OutlierDetectionDecision decision = this.decide(ctx, headers, cause);
            if (decision == null || decision == OutlierDetectionDecision.NEXT) {
                return other.decide(ctx, headers, cause);
            }
            return decision;
        };
    }
}

