/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.outlier;

import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.common.outlier.DefaultOutlierDetection;
import io.opentelemetry.testing.internal.armeria.common.outlier.OutlierDetection;
import io.opentelemetry.testing.internal.armeria.common.outlier.OutlierRule;
import io.opentelemetry.testing.internal.armeria.common.util.Ticker;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import java.time.Duration;
import java.util.Objects;

@UnstableApi
public final class OutlierDetectionBuilder {
    private static final int DEFAULT_COUNTER_SLIDING_WINDOW_SECONDS = 20;
    private static final int DEFAULT_COUNTER_UPDATE_INTERVAL_SECONDS = 1;
    private static final double DEFAULT_FAILURE_RATE_THRESHOLD = 0.5;
    private static final long DEFAULT_MINIMUM_REQUEST_THRESHOLD = 10L;
    static final OutlierDetection DEFAULT_DETECTION = OutlierDetection.builder(OutlierRule.of()).build();
    private final OutlierRule rule;
    private Ticker ticker = Ticker.systemTicker();
    private Duration counterSlidingWindow = Duration.ofSeconds(20L);
    private Duration counterUpdateInterval = Duration.ofSeconds(1L);
    private double failureRateThreshold = 0.5;
    private long minimumRequestThreshold = 10L;

    OutlierDetectionBuilder(OutlierRule rule) {
        Objects.requireNonNull(rule, "rule");
        this.rule = rule;
    }

    public OutlierDetectionBuilder ticker(Ticker ticker) {
        Objects.requireNonNull(ticker, "ticker");
        this.ticker = ticker;
        return this;
    }

    public OutlierDetectionBuilder counterSlidingWindow(Duration counterSlidingWindow) {
        Objects.requireNonNull(counterSlidingWindow, "counterSlidingWindow");
        Preconditions.checkArgument(!counterSlidingWindow.isNegative() && !counterSlidingWindow.isZero(), "counterSlidingWindow: %s (expected: > 0)", (Object)counterSlidingWindow);
        this.counterSlidingWindow = counterSlidingWindow;
        return this;
    }

    public OutlierDetectionBuilder counterSlidingWindowMillis(long counterSlidingWindowMillis) {
        return this.counterSlidingWindow(Duration.ofMillis(counterSlidingWindowMillis));
    }

    public OutlierDetectionBuilder counterUpdateInterval(Duration counterUpdateInterval) {
        Objects.requireNonNull(counterUpdateInterval, "counterUpdateInterval");
        Preconditions.checkArgument(!counterUpdateInterval.isNegative() && !counterUpdateInterval.isZero(), "counterUpdateInterval: %s (expected: > 0)", (Object)counterUpdateInterval);
        this.counterUpdateInterval = counterUpdateInterval;
        return this;
    }

    public OutlierDetectionBuilder counterUpdateIntervalMillis(long counterUpdateIntervalMillis) {
        return this.counterUpdateInterval(Duration.ofMillis(counterUpdateIntervalMillis));
    }

    public OutlierDetectionBuilder failureRateThreshold(double failureRateThreshold) {
        if (failureRateThreshold <= 0.0 || 1.0 < failureRateThreshold) {
            throw new IllegalArgumentException("failureRateThreshold: " + failureRateThreshold + " (expected: > 0 and <= 1)");
        }
        this.failureRateThreshold = failureRateThreshold;
        return this;
    }

    public OutlierDetectionBuilder minimumRequestThreshold(long minimumRequestThreshold) {
        if (minimumRequestThreshold < 0L) {
            throw new IllegalArgumentException("minimumRequestThreshold: " + minimumRequestThreshold + " (expected: >= 0)");
        }
        this.minimumRequestThreshold = minimumRequestThreshold;
        return this;
    }

    public OutlierDetection build() {
        return new DefaultOutlierDetection(this.rule, this.ticker, this.counterSlidingWindow, this.counterUpdateInterval, this.failureRateThreshold, this.minimumRequestThreshold);
    }
}

