/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.multipart;

import io.opentelemetry.testing.internal.armeria.common.ContentDisposition;
import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.MediaType;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.multipart.BodyPart;
import io.opentelemetry.testing.internal.armeria.common.multipart.DefaultBodyPart;
import io.opentelemetry.testing.internal.armeria.common.stream.ByteStreamMessage;
import io.opentelemetry.testing.internal.armeria.common.stream.PathStreamMessageBuilder;
import io.opentelemetry.testing.internal.armeria.common.stream.StreamMessage;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableCollection;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import java.io.File;
import java.nio.file.Path;
import java.util.Objects;
import org.reactivestreams.Publisher;

public final class BodyPartBuilder {
    private final ImmutableList.Builder<Publisher<? extends HttpData>> contentsBuilder = ImmutableList.builder();
    private HttpHeaders headers = HttpHeaders.of();

    BodyPartBuilder() {
    }

    public BodyPartBuilder headers(HttpHeaders headers) {
        Objects.requireNonNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public BodyPartBuilder content(Publisher<? extends HttpData> publisher) {
        Objects.requireNonNull(publisher, "publisher");
        this.contentsBuilder.add((Object)publisher);
        return this;
    }

    public BodyPartBuilder content(CharSequence content) {
        Objects.requireNonNull(content, "content");
        return this.content(HttpData.ofUtf8(content));
    }

    public BodyPartBuilder content(byte[] contents) {
        Objects.requireNonNull(contents, "contents");
        return this.content(HttpData.copyOf(contents));
    }

    public BodyPartBuilder content(File file) {
        Objects.requireNonNull(file, "file");
        return this.content(file.toPath());
    }

    public BodyPartBuilder content(File file, int bufferSize) {
        Objects.requireNonNull(file, "file");
        return this.content(file.toPath(), bufferSize);
    }

    public BodyPartBuilder content(Path path) {
        Objects.requireNonNull(path, "path");
        return this.content(StreamMessage.of(path));
    }

    public BodyPartBuilder content(Path path, int bufferSize) {
        Objects.requireNonNull(path, "path");
        return this.content(((PathStreamMessageBuilder)StreamMessage.builder(path).bufferSize(bufferSize)).build());
    }

    public BodyPartBuilder content(HttpData content) {
        Objects.requireNonNull(content, "content");
        return this.content(StreamMessage.of(content));
    }

    private static MediaType defaultContentType(@Nullable ContentDisposition contentDisposition) {
        if (contentDisposition != null && contentDisposition.filename() != null) {
            return MediaType.OCTET_STREAM;
        }
        return MediaType.PLAIN_TEXT;
    }

    public BodyPart build() {
        HttpHeaders headers;
        ImmutableCollection contents = this.contentsBuilder.build();
        Preconditions.checkState(!contents.isEmpty(), "Should set at least one content");
        if (this.headers.contentType() == null) {
            MediaType defaultContentType = BodyPartBuilder.defaultContentType(this.headers.contentDisposition());
            headers = this.headers.withMutations(builder -> builder.contentType(defaultContentType));
        } else {
            headers = this.headers;
        }
        return new DefaultBodyPart(headers, ByteStreamMessage.of(StreamMessage.concat(contents)));
    }
}

