/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.metric;

import io.opentelemetry.testing.internal.armeria.common.Flags;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.common.metric.CertificateMetrics;
import io.opentelemetry.testing.internal.armeria.common.metric.CloseableMeterBinder;
import io.opentelemetry.testing.internal.armeria.common.metric.EventLoopMetrics;
import io.opentelemetry.testing.internal.armeria.common.metric.MeterIdPrefix;
import io.opentelemetry.testing.internal.armeria.internal.common.util.CertificateUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.binder.netty4.NettyAllocatorMetrics;
import io.opentelemetry.testing.internal.io.netty.buffer.ByteBufAllocator;
import io.opentelemetry.testing.internal.io.netty.buffer.ByteBufAllocatorMetricProvider;
import io.opentelemetry.testing.internal.io.netty.channel.EventLoopGroup;
import java.io.File;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Objects;

public final class MoreMeterBinders {
    @UnstableApi
    public static CloseableMeterBinder eventLoopMetrics(EventLoopGroup eventLoopGroup, String name) {
        Objects.requireNonNull(name, "name");
        return MoreMeterBinders.eventLoopMetrics(eventLoopGroup, new MeterIdPrefix("armeria.netty." + name));
    }

    @UnstableApi
    public static CloseableMeterBinder eventLoopMetrics(EventLoopGroup eventLoopGroup, MeterIdPrefix meterIdPrefix) {
        return new EventLoopMetrics(eventLoopGroup, meterIdPrefix);
    }

    @UnstableApi
    public static CloseableMeterBinder certificateMetrics(X509Certificate certificate, MeterIdPrefix meterIdPrefix) {
        Objects.requireNonNull(certificate, "certificate");
        return MoreMeterBinders.certificateMetrics(ImmutableList.of(certificate), meterIdPrefix);
    }

    @UnstableApi
    public static CloseableMeterBinder certificateMetrics(Iterable<? extends X509Certificate> certificates, MeterIdPrefix meterIdPrefix) {
        Objects.requireNonNull(certificates, "certificates");
        Objects.requireNonNull(meterIdPrefix, "meterIdPrefix");
        return new CertificateMetrics(ImmutableList.copyOf(certificates), meterIdPrefix);
    }

    @UnstableApi
    public static CloseableMeterBinder certificateMetrics(File keyCertChainFile, MeterIdPrefix meterIdPrefix) throws CertificateException {
        Objects.requireNonNull(keyCertChainFile, "keyCertChainFile");
        return MoreMeterBinders.certificateMetrics(CertificateUtil.toX509Certificates(keyCertChainFile), meterIdPrefix);
    }

    @UnstableApi
    public static CloseableMeterBinder certificateMetrics(InputStream keyCertChainFile, MeterIdPrefix meterIdPrefix) throws CertificateException {
        Objects.requireNonNull(keyCertChainFile, "keyCertChainFile");
        return MoreMeterBinders.certificateMetrics(CertificateUtil.toX509Certificates(keyCertChainFile), meterIdPrefix);
    }

    private MoreMeterBinders() {
    }

    static {
        ByteBufAllocator alloc = ByteBufAllocator.DEFAULT;
        if (alloc instanceof ByteBufAllocatorMetricProvider) {
            new NettyAllocatorMetrics((ByteBufAllocatorMetricProvider)((Object)alloc)).bindTo(Flags.meterRegistry());
        }
    }
}

