/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.logging;

import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.common.logging.ContentSanitizer;
import io.opentelemetry.testing.internal.armeria.common.logging.FieldMaskerSelector;
import io.opentelemetry.testing.internal.armeria.internal.common.JacksonUtil;
import io.opentelemetry.testing.internal.armeria.internal.common.logging.FieldMaskerSelectorProvider;
import io.opentelemetry.testing.internal.armeria.internal.common.logging.MaskerAttributeKeys;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableCollection;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableMap;
import io.opentelemetry.testing.internal.jackson.core.JsonProcessingException;
import io.opentelemetry.testing.internal.jackson.databind.JsonNode;
import io.opentelemetry.testing.internal.jackson.databind.ObjectMapper;
import io.opentelemetry.testing.internal.jackson.databind.util.RawValue;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;

@UnstableApi
public final class ContentSanitizerBuilder {
    private static final Map<Class<?>, FieldMaskerSelectorProvider<?>> customizersMap;
    private final ImmutableList.Builder<FieldMaskerSelector<?>> maskerListBuilder = ImmutableList.builder();

    ContentSanitizerBuilder() {
    }

    public ContentSanitizerBuilder fieldMaskerSelector(FieldMaskerSelector<?> masker) {
        Objects.requireNonNull(masker, "masker");
        Preconditions.checkArgument(!customizersMap.containsKey(masker.getClass()), "Specified masker should be one of the following types: %s", customizersMap.keySet());
        this.maskerListBuilder.add((Object)masker);
        return this;
    }

    public ContentSanitizer<String> buildForText() {
        ObjectMapper objectMapper = this.buildObjectMapper();
        return (requestContext, o) -> {
            try {
                return objectMapper.writer().withAttribute(MaskerAttributeKeys.REQUEST_CONTEXT_KEY, requestContext).writeValueAsString(o);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public ContentSanitizer<JsonNode> buildForJson() {
        ObjectMapper objectMapper = this.buildObjectMapper();
        return (requestContext, o) -> {
            try {
                String ser = objectMapper.writer().withAttribute(MaskerAttributeKeys.REQUEST_CONTEXT_KEY, requestContext).writeValueAsString(o);
                return objectMapper.createObjectNode().rawValueNode(new RawValue(ser));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public ObjectMapper buildObjectMapper() {
        ImmutableCollection fieldMaskerSelectors = this.maskerListBuilder.build();
        ObjectMapper objectMapper = JacksonUtil.newDefaultObjectMapper();
        for (FieldMaskerSelectorProvider<?> customizer : customizersMap.values()) {
            ContentSanitizerBuilder.applyProvider(customizer, objectMapper, fieldMaskerSelectors);
        }
        return objectMapper;
    }

    private static <T extends FieldMaskerSelector<?>> void applyProvider(FieldMaskerSelectorProvider<T> provider, ObjectMapper objectMapper, List<FieldMaskerSelector<?>> selectors) {
        List filtered = selectors.stream().filter(selector -> provider.supportedType().isInstance(selector)).map(selector -> selector).collect(ImmutableList.toImmutableList());
        provider.customize(filtered, objectMapper);
    }

    static {
        ImmutableMap.Builder customizersMapBuilder = ImmutableMap.builder();
        ServiceLoader<FieldMaskerSelectorProvider> loader = ServiceLoader.load(FieldMaskerSelectorProvider.class, ContentSanitizerBuilder.class.getClassLoader());
        for (FieldMaskerSelectorProvider customizer : loader) {
            customizersMapBuilder.put(customizer.supportedType(), customizer);
        }
        customizersMap = customizersMapBuilder.buildKeepingLast();
    }
}

