/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.loadbalancer;

import io.opentelemetry.testing.internal.armeria.common.loadbalancer.WeightTransition;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.primitives.Ints;

final class AggregationWeightTransition<T>
implements WeightTransition<T> {
    private final double aggressionPercentage;
    private final double invertedAggression;
    private final double minWeightPercent;

    AggregationWeightTransition(double aggression, double minWeightPercent) {
        this.aggressionPercentage = Ints.saturatedCast(Math.round(aggression * 100.0));
        this.invertedAggression = 100.0 / this.aggressionPercentage;
        this.minWeightPercent = minWeightPercent;
    }

    @Override
    public int compute(T candidate, int weight, int currentStep, int totalSteps) {
        int minWeight = Ints.saturatedCast(Math.round((double)weight * this.minWeightPercent));
        int computedWeight = this.aggressionPercentage == 100.0 ? WeightTransition.linear().compute(candidate, weight, currentStep, totalSteps) : (int)((double)weight * Math.pow(1.0 * (double)currentStep / (double)totalSteps, this.invertedAggression));
        return Math.max(computedWeight, minWeight);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("aggressionPercentage", this.aggressionPercentage).add("invertedAggression", this.invertedAggression).add("minWeightPercent", this.minWeightPercent).toString();
    }
}

