/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.encoding;

import io.opentelemetry.testing.internal.armeria.common.encoding.AbstractStreamDecoder;
import io.opentelemetry.testing.internal.io.netty.buffer.ByteBufAllocator;
import io.opentelemetry.testing.internal.io.netty.handler.codec.compression.JZlibDecoder;
import io.opentelemetry.testing.internal.io.netty.handler.codec.compression.JdkZlibDecoder;
import io.opentelemetry.testing.internal.io.netty.handler.codec.compression.ZlibDecoder;
import io.opentelemetry.testing.internal.io.netty.handler.codec.compression.ZlibWrapper;
import io.opentelemetry.testing.internal.io.netty.util.internal.SystemPropertyUtil;

final class ZlibStreamDecoder
extends AbstractStreamDecoder {
    private static final boolean noJdkZlibDecoder = SystemPropertyUtil.getBoolean("io.opentelemetry.testing.internal.io.netty.noJdkZlibDecoder", false);

    ZlibStreamDecoder(ZlibWrapper zlibWrapper, ByteBufAllocator alloc, int maxLength) {
        super(ZlibStreamDecoder.newZlibDecoder(zlibWrapper, maxLength), alloc, maxLength);
    }

    private static ZlibDecoder newZlibDecoder(ZlibWrapper wrapper, int maxLength) {
        if (noJdkZlibDecoder) {
            return new JZlibDecoder(wrapper, maxLength);
        }
        return new JdkZlibDecoder(wrapper, true, maxLength);
    }
}

