/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.encoding;

import io.opentelemetry.testing.internal.armeria.common.ContentTooLargeException;
import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.encoding.StreamDecoder;
import io.opentelemetry.testing.internal.io.netty.buffer.ByteBuf;
import io.opentelemetry.testing.internal.io.netty.buffer.ByteBufAllocator;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelHandler;
import io.opentelemetry.testing.internal.io.netty.channel.embedded.EmbeddedChannel;
import io.opentelemetry.testing.internal.io.netty.handler.codec.compression.DecompressionException;

class AbstractStreamDecoder
implements StreamDecoder {
    private final EmbeddedChannel decoder;
    private final int maxLength;
    private int decodedLength;

    protected AbstractStreamDecoder(ChannelHandler handler, ByteBufAllocator alloc, int maxLength) {
        this.decoder = new EmbeddedChannel(false, handler);
        this.decoder.config().setAllocator(alloc);
        this.maxLength = maxLength;
    }

    @Override
    public HttpData decode(HttpData obj) {
        try {
            this.decoder.writeInbound(obj.byteBuf());
        }
        catch (DecompressionException ex) {
            String message = ex.getMessage();
            if (message != null && message.startsWith("Decompression buffer has reached maximum size:")) {
                throw ContentTooLargeException.builder().maxContentLength(this.maxLength).cause(ex).build();
            }
            throw ex;
        }
        return this.fetchDecoderOutput();
    }

    @Override
    public HttpData finish() {
        if (this.decoder.finish()) {
            return this.fetchDecoderOutput();
        }
        return HttpData.empty();
    }

    @Override
    public int maxLength() {
        return this.maxLength;
    }

    protected HttpData fetchDecoderOutput() {
        ByteBuf buf;
        ByteBuf decoded = null;
        while ((buf = (ByteBuf)this.decoder.readInbound()) != null) {
            if (!buf.isReadable()) {
                buf.release();
                continue;
            }
            this.maybeCheckOverflow(decoded, buf);
            if (decoded == null) {
                decoded = buf;
                continue;
            }
            try {
                decoded.writeBytes(buf);
            }
            finally {
                buf.release();
            }
        }
        if (decoded == null) {
            return HttpData.empty();
        }
        return HttpData.wrap(decoded);
    }

    private void maybeCheckOverflow(@Nullable ByteBuf decoded, ByteBuf newBuf) {
        if (this.maxLength <= 0 || this.maxLength == Integer.MAX_VALUE) {
            return;
        }
        this.decodedLength += newBuf.readableBytes();
        if (this.decodedLength > this.maxLength) {
            if (decoded != null) {
                decoded.release();
            }
            newBuf.release();
            throw ContentTooLargeException.builder().maxContentLength(this.maxLength).transferred(this.decodedLength).build();
        }
    }
}

