/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.MappedTlsProvider;
import io.opentelemetry.testing.internal.armeria.common.StaticTlsProvider;
import io.opentelemetry.testing.internal.armeria.common.TlsKeyPair;
import io.opentelemetry.testing.internal.armeria.common.TlsProvider;
import io.opentelemetry.testing.internal.armeria.internal.common.TlsProviderUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableMap;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Objects;

public final class TlsProviderBuilder {
    private final ImmutableMap.Builder<String, TlsKeyPair> tlsKeyPairsBuilder = ImmutableMap.builder();
    private final ImmutableMap.Builder<String, List<X509Certificate>> x509CertificateBuilder = ImmutableMap.builder();

    TlsProviderBuilder() {
    }

    public TlsProviderBuilder keyPair(String hostname, TlsKeyPair tlsKeyPair) {
        Objects.requireNonNull(hostname, "hostname");
        Objects.requireNonNull(tlsKeyPair, "tlsKeyPair");
        this.tlsKeyPairsBuilder.put(TlsProviderBuilder.normalize(hostname), tlsKeyPair);
        return this;
    }

    public TlsProviderBuilder keyPair(TlsKeyPair tlsKeyPair) {
        return this.keyPair("*", tlsKeyPair);
    }

    public TlsProviderBuilder trustedCertificates(String hostname, X509Certificate ... trustedCertificates) {
        Objects.requireNonNull(trustedCertificates, "trustedCertificates");
        return this.trustedCertificates(hostname, ImmutableList.copyOf(trustedCertificates));
    }

    public TlsProviderBuilder trustedCertificates(String hostname, Iterable<? extends X509Certificate> trustedCertificates) {
        Objects.requireNonNull(hostname, "hostname");
        Objects.requireNonNull(trustedCertificates, "trustedCertificates");
        this.x509CertificateBuilder.put(TlsProviderBuilder.normalize(hostname), ImmutableList.copyOf(trustedCertificates));
        return this;
    }

    public TlsProviderBuilder trustedCertificates(X509Certificate ... trustedCertificates) {
        Objects.requireNonNull(trustedCertificates, "trustedCertificates");
        return this.trustedCertificates(ImmutableList.copyOf(trustedCertificates));
    }

    public TlsProviderBuilder trustedCertificates(Iterable<? extends X509Certificate> trustedCertificates) {
        return this.trustedCertificates("*", trustedCertificates);
    }

    private static String normalize(String hostname) {
        if ("*".equals(hostname)) {
            return "*";
        }
        return TlsProviderUtil.normalizeHostname(hostname);
    }

    public TlsProvider build() {
        ImmutableMap<String, TlsKeyPair> keyPairMappings = this.tlsKeyPairsBuilder.build();
        if (keyPairMappings.isEmpty()) {
            throw new IllegalStateException("No TLS key pair is set.");
        }
        ImmutableMap<String, List<X509Certificate>> trustedCerts = this.x509CertificateBuilder.build();
        if (keyPairMappings.size() == 1 && keyPairMappings.containsKey("*") && trustedCerts.isEmpty()) {
            return new StaticTlsProvider((TlsKeyPair)keyPairMappings.get("*"));
        }
        return new MappedTlsProvider(keyPairMappings, trustedCerts);
    }
}

