/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.common.RpcResponse;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.common.logging.RequestLog;

@FunctionalInterface
@UnstableApi
public interface SuccessFunction {
    public static SuccessFunction never() {
        return (ctx, log) -> false;
    }

    public static SuccessFunction always() {
        return (ctx, log) -> true;
    }

    public static SuccessFunction ofDefault() {
        return (ctx, log) -> {
            if (log.responseCause() != null) {
                return false;
            }
            int statusCode = log.responseHeaders().status().code();
            if (statusCode < 100 || statusCode >= 400) {
                return false;
            }
            Object responseContent = log.responseContent();
            if (responseContent instanceof RpcResponse) {
                return !((RpcResponse)responseContent).isCompletedExceptionally();
            }
            return true;
        };
    }

    public boolean isSuccess(RequestContext var1, RequestLog var2);
}

