/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.TlsKeyPair;
import io.opentelemetry.testing.internal.armeria.common.TlsProvider;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RefreshingTlsProvider
implements TlsProvider {
    private static final Logger logger = LoggerFactory.getLogger(RefreshingTlsProvider.class);
    private final Supplier<TlsKeyPair> keyPairSupplier;
    private final Duration interval;
    private final ScheduledExecutorService executor;
    private final ScheduledFuture<?> scheduledFuture;
    private final List<X509Certificate> certificates;
    private volatile TlsKeyPair keyPair;

    RefreshingTlsProvider(Supplier<TlsKeyPair> keyPairSupplier, List<X509Certificate> certificates, @Nullable Consumer<TlsKeyPair> onKeyPairUpdated, Duration interval, ScheduledExecutorService executor) {
        this.keyPairSupplier = keyPairSupplier;
        this.certificates = certificates;
        this.interval = interval;
        this.executor = executor;
        this.keyPair = keyPairSupplier.get();
        Objects.requireNonNull(this.keyPair, "keyPairSupplier returned null");
        this.scheduledFuture = executor.scheduleAtFixedRate(() -> {
            try {
                TlsKeyPair newKeyPair = (TlsKeyPair)keyPairSupplier.get();
                Objects.requireNonNull(newKeyPair, "keyPairSupplier returned null");
                if (!Objects.equals(this.keyPair, newKeyPair)) {
                    this.keyPair = newKeyPair;
                    if (onKeyPairUpdated != null) {
                        try {
                            onKeyPairUpdated.accept(newKeyPair);
                        }
                        catch (Throwable t) {
                            logger.warn("Failed to notify TLS key pair update listeners", t);
                        }
                    }
                }
            }
            catch (Throwable t) {
                logger.warn("Failed to refresh a new TlsKeyPair:", t);
            }
        }, interval.toMillis(), interval.toMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public TlsKeyPair keyPair(String hostname) {
        return this.keyPair;
    }

    @Override
    public List<X509Certificate> trustedCertificates(String hostname) {
        return this.certificates;
    }

    @Override
    public void close() {
        this.scheduledFuture.cancel(true);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("keyPairSupplier", this.keyPairSupplier).add("interval", this.interval).add("executor", this.executor).add("keyPair", this.keyPair).toString();
    }
}

