/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.AbstractContextAwareExecutor;
import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Function;

final class PropagatingContextAwareExecutor
extends AbstractContextAwareExecutor<Executor> {
    static PropagatingContextAwareExecutor of(Executor executor) {
        Objects.requireNonNull(executor, "executor");
        if (executor instanceof PropagatingContextAwareExecutor) {
            return (PropagatingContextAwareExecutor)executor;
        }
        return new PropagatingContextAwareExecutor(executor);
    }

    private PropagatingContextAwareExecutor(Executor executor) {
        super(executor);
    }

    @Override
    @Nullable
    RequestContext contextOrNull() {
        return RequestContext.mapCurrent(Function.identity(), AbstractContextAwareExecutor.LogRequestContextWarningOnce.INSTANCE);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("executor", this.withoutContext()).toString();
    }
}

