/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.TlsKeyPair;
import io.opentelemetry.testing.internal.armeria.common.TlsProvider;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.common.TlsProviderUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.Objects;

final class MappedTlsProvider
implements TlsProvider {
    private final Map<String, TlsKeyPair> tlsKeyPairs;
    private final Map<String, List<X509Certificate>> trustedCertificates;

    MappedTlsProvider(Map<String, TlsKeyPair> tlsKeyPairs, Map<String, List<X509Certificate>> trustedCertificates) {
        this.tlsKeyPairs = tlsKeyPairs;
        this.trustedCertificates = trustedCertificates;
    }

    @Override
    @Nullable
    public TlsKeyPair keyPair(String hostname) {
        Objects.requireNonNull(hostname, "hostname");
        return MappedTlsProvider.find(hostname, this.tlsKeyPairs);
    }

    @Override
    public List<X509Certificate> trustedCertificates(String hostname) {
        List<X509Certificate> certs = MappedTlsProvider.find(hostname, this.trustedCertificates);
        return MoreObjects.firstNonNull(certs, ImmutableList.of());
    }

    @Nullable
    private static <T> T find(String hostname, Map<String, T> map) {
        if ("*".equals(hostname)) {
            return map.get("*");
        }
        T value = map.get(hostname = TlsProviderUtil.normalizeHostname(hostname));
        if (value != null) {
            return value;
        }
        int idx = hostname.indexOf(46);
        if (idx != -1 && (value = map.get(hostname.substring(idx))) != null) {
            return value;
        }
        return map.get("*");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MappedTlsProvider)) {
            return false;
        }
        MappedTlsProvider that = (MappedTlsProvider)o;
        return this.tlsKeyPairs.equals(that.tlsKeyPairs) && this.trustedCertificates.equals(that.trustedCertificates);
    }

    public int hashCode() {
        return Objects.hash(this.tlsKeyPairs, this.trustedCertificates);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("tlsKeyPairs", this.tlsKeyPairs).add("trustedCertificates", this.trustedCertificates).toString();
    }
}

