/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.AggregatedHttpResponse;
import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.HttpObject;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.HttpResponseUtil;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeaders;
import io.opentelemetry.testing.internal.armeria.common.stream.StreamWriter;
import java.util.Objects;

public interface HttpResponseWriter
extends HttpResponse,
StreamWriter<HttpObject> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void close(AggregatedHttpResponse res) {
        boolean transferredContent = false;
        HttpData content = null;
        try {
            HttpHeaders trailers;
            Objects.requireNonNull(res, "res");
            ResponseHeaders headers = res.headers();
            content = res.content();
            if (!this.tryWrite(headers)) {
                return;
            }
            if (headers.status().isContentAlwaysEmpty()) {
                if (!content.isEmpty()) {
                    HttpResponseUtil.httpResponseUtilLogger.debug("Non-empty content found with an empty status: {}, content length: {}", (Object)headers.status(), (Object)content.length());
                }
            } else if (!content.isEmpty()) {
                transferredContent = true;
                if (!this.tryWrite(content)) {
                    return;
                }
            }
            if (!(trailers = res.trailers()).isEmpty()) {
                boolean bl = this.tryWrite(trailers);
            }
        }
        finally {
            this.close();
            if (!transferredContent && content != null) {
                content.close();
            }
        }
    }
}

