/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.io.netty.util.AsciiString;
import io.opentelemetry.testing.internal.jackson.core.JsonGenerator;
import io.opentelemetry.testing.internal.jackson.databind.SerializerProvider;
import io.opentelemetry.testing.internal.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.List;

final class HttpHeadersJsonSerializer
extends StdSerializer<HttpHeaders> {
    private static final long serialVersionUID = 4459242879396343114L;

    HttpHeadersJsonSerializer() {
        super(HttpHeaders.class);
    }

    @Override
    public void serialize(HttpHeaders headers, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        for (AsciiString name : headers.names()) {
            gen.writeFieldName(name.toString());
            List<String> values = headers.getAll(name);
            if (values.size() == 1) {
                gen.writeString(values.get(0));
                continue;
            }
            gen.writeStartArray();
            for (String value : values) {
                gen.writeString(value);
            }
            gen.writeEndArray();
        }
        gen.writeEndObject();
    }
}

