/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.ContextAwareBiFunction;
import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.common.util.SafeCloseable;
import io.opentelemetry.testing.internal.armeria.internal.common.context.ArmeriaContextPropagation;
import io.opentelemetry.testing.internal.io.micrometer.context.ContextSnapshot;
import java.util.Objects;
import java.util.function.BiFunction;

final class DefaultContextAwareBiFunction<T, U, R>
implements ContextAwareBiFunction<T, U, R> {
    private final RequestContext context;
    private final BiFunction<T, U, R> function;
    private final ContextSnapshot contextSnapshot;

    DefaultContextAwareBiFunction(RequestContext context, BiFunction<T, U, R> function) {
        this.context = Objects.requireNonNull(context, "context");
        this.function = Objects.requireNonNull(function, "function");
        this.contextSnapshot = ArmeriaContextPropagation.captureAll();
    }

    @Override
    public RequestContext context() {
        return this.context;
    }

    @Override
    public BiFunction<T, U, R> withoutContext() {
        return this.function;
    }

    @Override
    public R apply(T t, U u) {
        try (SafeCloseable ignored = this.context.push();){
            R r;
            block12: {
                ContextSnapshot.Scope ignored2 = this.contextSnapshot.setThreadLocals();
                try {
                    r = this.function.apply(t, u);
                    if (ignored2 == null) break block12;
                    ignored2.close();
                }
                catch (Throwable throwable) {
                    if (ignored2 != null) {
                        try {
                            ignored2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            return r;
        }
    }
}

