/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.NonBlocking;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.reactor.blockhound.BlockHound;
import io.opentelemetry.testing.internal.reactor.blockhound.integration.BlockHoundIntegration;
import java.util.ResourceBundle;

@UnstableApi
public final class CoreBlockHoundIntegration
implements BlockHoundIntegration {
    public void applyTo(BlockHound.Builder builder) {
        builder.nonBlockingThreadPredicate(predicate -> predicate.or(NonBlocking.class::isInstance));
        builder.allowBlockingCallsInside("io.opentelemetry.testing.internal.armeria.client.HttpClientFactory", "pool");
        builder.allowBlockingCallsInside("io.opentelemetry.testing.internal.armeria.internal.common.util.ReentrantShortLock", "lock");
        builder.allowBlockingCallsInside("io.opentelemetry.testing.internal.io.netty.util.internal.ReferenceCountUpdater", "release");
        builder.allowBlockingCallsInside("io.opentelemetry.testing.internal.org.hdrhistogram.ConcurrentHistogram", "getCountAtIndex");
        builder.allowBlockingCallsInside("io.opentelemetry.testing.internal.org.hdrhistogram.WriterReaderPhaser", "flipPhase");
        builder.allowBlockingCallsInside("java.util.concurrent.LinkedBlockingQueue", "offer");
        builder.allowBlockingCallsInside("io.opentelemetry.testing.internal.armeria.internal.client.PublicSuffix", "get");
        builder.allowBlockingCallsInside("java.util.ServiceLoader$LazyClassPathLookupIterator", "parse");
        builder.allowBlockingCallsInside(ResourceBundle.class.getName(), "getBundle");
        builder.allowBlockingCallsInside("io.opentelemetry.testing.internal.io.netty.handler.codec.compression.Brotli", "<clinit>");
        builder.allowBlockingCallsInside("java.util.concurrent.ThreadPoolExecutor", "addWorker");
        builder.allowBlockingCallsInside("io.opentelemetry.testing.internal.armeria.server.metric.PrometheusExpositionService", "doGet");
        builder.allowBlockingCallsInside("java.util.concurrent.FutureTask", "handlePossibleCancellationInterrupt");
        builder.allowBlockingCallsInside("io.opentelemetry.testing.internal.io.netty.handler.ssl.SslContext", "buildKeyStore");
        builder.allowBlockingCallsInside("io.opentelemetry.testing.internal.io.netty.buffer.AdaptivePoolingAllocator", "allocate");
    }
}

