/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.common.util.SafeCloseable;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.Future;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.GenericProgressiveFutureListener;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.ProgressiveFuture;
import java.util.Objects;

final class ContextAwareProgressiveFutureListener
implements GenericProgressiveFutureListener {
    private final RequestContext ctx;
    private final GenericProgressiveFutureListener listener;

    static <T extends ProgressiveFuture<?>> GenericProgressiveFutureListener<T> of(RequestContext ctx, GenericProgressiveFutureListener listener) {
        Objects.requireNonNull(ctx, "ctx");
        Objects.requireNonNull(listener, "listener");
        return new ContextAwareProgressiveFutureListener(ctx, listener);
    }

    private ContextAwareProgressiveFutureListener(RequestContext ctx, GenericProgressiveFutureListener listener) {
        this.ctx = ctx;
        this.listener = listener;
    }

    public void operationProgressed(ProgressiveFuture future, long progress, long total) throws Exception {
        try (SafeCloseable ignored = this.ctx.push();){
            this.listener.operationProgressed(future, progress, total);
        }
    }

    @Override
    public void operationComplete(Future future) throws Exception {
        try (SafeCloseable ignored = this.ctx.push();){
            this.listener.operationComplete(future);
        }
    }
}

