/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.ContextHolder;
import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.common.util.SafeCloseable;
import io.opentelemetry.testing.internal.armeria.internal.common.RequestContextUtil;
import io.opentelemetry.testing.internal.armeria.internal.common.util.TemporaryThreadLocals;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.Marker;

final class ContextAwareLogger
implements ContextHolder,
Logger {
    private final RequestContext ctx;
    private final Logger logger;

    static Logger of(RequestContext ctx, Logger logger) {
        Objects.requireNonNull(ctx, "ctx");
        Objects.requireNonNull(logger, "logger");
        if (logger instanceof ContextHolder) {
            RequestContextUtil.ensureSameCtx(ctx, (ContextHolder)logger, ContextAwareLogger.class);
            return logger;
        }
        return new ContextAwareLogger(ctx, logger);
    }

    private ContextAwareLogger(RequestContext ctx, Logger logger) {
        this.ctx = ctx;
        this.logger = logger;
    }

    @Override
    public RequestContext context() {
        return this.ctx;
    }

    private String decorate(String msg) {
        String prefix = this.ctx.toString();
        try (TemporaryThreadLocals tempThreadLocals = TemporaryThreadLocals.acquire();){
            String string = tempThreadLocals.stringBuilder().append(prefix).append(' ').append(msg).toString();
            return string;
        }
    }

    public String getName() {
        return this.logger.getName();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.logger.isTraceEnabled(marker);
    }

    public void trace(String msg) {
        if (this.isTraceEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.trace(this.decorate(msg));
            }
        }
    }

    public void trace(String format, Object arg) {
        if (this.isTraceEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.trace(this.decorate(format), arg);
            }
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.trace(this.decorate(format), arg1, arg2);
            }
        }
    }

    public void trace(String format, Object ... arguments) {
        if (this.isTraceEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.trace(this.decorate(format), arguments);
            }
        }
    }

    public void trace(String msg, Throwable t) {
        if (this.isTraceEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.trace(this.decorate(msg), t);
            }
        }
    }

    public void trace(Marker marker, String msg) {
        if (this.isTraceEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.trace(marker, this.decorate(msg));
            }
        }
    }

    public void trace(Marker marker, String format, Object arg) {
        if (this.isTraceEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.trace(marker, this.decorate(format), arg);
            }
        }
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isTraceEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.trace(marker, this.decorate(format), arg1, arg2);
            }
        }
    }

    public void trace(Marker marker, String format, Object ... argArray) {
        if (this.isTraceEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.trace(marker, this.decorate(format), argArray);
            }
        }
    }

    public void trace(Marker marker, String msg, Throwable t) {
        if (this.isTraceEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.trace(marker, this.decorate(msg), t);
            }
        }
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.logger.isDebugEnabled(marker);
    }

    public void debug(String msg) {
        if (this.isDebugEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.debug(this.decorate(msg));
            }
        }
    }

    public void debug(String format, Object arg) {
        if (this.isDebugEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.debug(this.decorate(format), arg);
            }
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.debug(this.decorate(format), arg1, arg2);
            }
        }
    }

    public void debug(String format, Object ... arguments) {
        if (this.isDebugEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.debug(this.decorate(format), arguments);
            }
        }
    }

    public void debug(String msg, Throwable t) {
        if (this.isDebugEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.debug(this.decorate(msg), t);
            }
        }
    }

    public void debug(Marker marker, String msg) {
        if (this.isDebugEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.debug(marker, this.decorate(msg));
            }
        }
    }

    public void debug(Marker marker, String format, Object arg) {
        if (this.isDebugEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.debug(marker, this.decorate(format), arg);
            }
        }
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.debug(marker, this.decorate(format), arg1, arg2);
            }
        }
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        if (this.isDebugEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.debug(marker, this.decorate(format), arguments);
            }
        }
    }

    public void debug(Marker marker, String msg, Throwable t) {
        if (this.isDebugEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.debug(marker, this.decorate(msg), t);
            }
        }
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.logger.isInfoEnabled(marker);
    }

    public void info(String msg) {
        if (this.isInfoEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.info(this.decorate(msg));
            }
        }
    }

    public void info(String format, Object arg) {
        if (this.isInfoEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.info(this.decorate(format), arg);
            }
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.info(this.decorate(format), arg1, arg2);
            }
        }
    }

    public void info(String format, Object ... arguments) {
        if (this.isInfoEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.info(this.decorate(format), arguments);
            }
        }
    }

    public void info(String msg, Throwable t) {
        if (this.isInfoEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.info(this.decorate(msg), t);
            }
        }
    }

    public void info(Marker marker, String msg) {
        if (this.isInfoEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.info(marker, this.decorate(msg));
            }
        }
    }

    public void info(Marker marker, String format, Object arg) {
        if (this.isInfoEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.info(this.decorate(format), (Object)format, arg);
            }
        }
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.info(marker, this.decorate(format), arg1, arg2);
            }
        }
    }

    public void info(Marker marker, String format, Object ... arguments) {
        if (this.isInfoEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.info(marker, this.decorate(format), arguments);
            }
        }
    }

    public void info(Marker marker, String msg, Throwable t) {
        if (this.isInfoEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.info(marker, this.decorate(msg), t);
            }
        }
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.logger.isWarnEnabled(marker);
    }

    public void warn(String msg) {
        if (this.isWarnEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.warn(this.decorate(msg));
            }
        }
    }

    public void warn(String format, Object arg) {
        if (this.isWarnEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.warn(this.decorate(format), arg);
            }
        }
    }

    public void warn(String format, Object ... arguments) {
        if (this.isWarnEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.warn(this.decorate(format), arguments);
            }
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.warn(this.decorate(format), arg1, arg2);
            }
        }
    }

    public void warn(String msg, Throwable t) {
        if (this.isWarnEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.warn(this.decorate(msg), t);
            }
        }
    }

    public void warn(Marker marker, String msg) {
        if (this.isWarnEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.warn(marker, this.decorate(msg));
            }
        }
    }

    public void warn(Marker marker, String format, Object arg) {
        if (this.isWarnEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.warn(marker, this.decorate(format), arg);
            }
        }
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.warn(marker, this.decorate(format), arg1, arg2);
            }
        }
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        if (this.isWarnEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.warn(marker, this.decorate(format), arguments);
            }
        }
    }

    public void warn(Marker marker, String msg, Throwable t) {
        if (this.isWarnEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.warn(marker, this.decorate(msg), t);
            }
        }
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.logger.isErrorEnabled(marker);
    }

    public void error(String msg) {
        if (this.isErrorEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.error(this.decorate(msg));
            }
        }
    }

    public void error(String format, Object arg) {
        if (this.isErrorEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.error(this.decorate(format), arg);
            }
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.error(this.decorate(format), arg1, arg2);
            }
        }
    }

    public void error(String format, Object ... arguments) {
        if (this.isErrorEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.error(this.decorate(format), arguments);
            }
        }
    }

    public void error(String msg, Throwable t) {
        if (this.isErrorEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.error(this.decorate(msg), t);
            }
        }
    }

    public void error(Marker marker, String msg) {
        if (this.isErrorEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.error(marker, this.decorate(msg));
            }
        }
    }

    public void error(Marker marker, String format, Object arg) {
        if (this.isErrorEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.error(marker, this.decorate(format), arg);
            }
        }
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.error(marker, this.decorate(format), arg1, arg2);
            }
        }
    }

    public void error(Marker marker, String format, Object ... arguments) {
        if (this.isErrorEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.error(marker, this.decorate(format), arguments);
            }
        }
    }

    public void error(Marker marker, String msg, Throwable t) {
        if (this.isErrorEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.error(marker, this.decorate(msg), t);
            }
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("context", this.ctx).add("logger", this.logger).toString();
    }
}

