/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.ContextAwareProgressiveFutureListener;
import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.common.util.SafeCloseable;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.Future;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.GenericFutureListener;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.GenericProgressiveFutureListener;

final class ContextAwareFutureListener
implements GenericFutureListener {
    private final RequestContext ctx;
    private final GenericFutureListener listener;

    static <T extends Future<?>> GenericFutureListener<T> of(RequestContext ctx, GenericFutureListener listener) {
        if (listener instanceof GenericProgressiveFutureListener) {
            return ContextAwareProgressiveFutureListener.of(ctx, (GenericProgressiveFutureListener)listener);
        }
        return new ContextAwareFutureListener(ctx, listener);
    }

    private ContextAwareFutureListener(RequestContext ctx, GenericFutureListener listener) {
        this.ctx = ctx;
        this.listener = listener;
    }

    public void operationComplete(Future future) throws Exception {
        try (SafeCloseable ignored = this.ctx.push();){
            this.listener.operationComplete(future);
        }
    }
}

