/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.ContextAwareExecutor;
import io.opentelemetry.testing.internal.armeria.common.DefaultContextAwareExecutorService;
import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.internal.common.RequestContextUtil;
import java.util.Objects;
import java.util.concurrent.ExecutorService;

public interface ContextAwareExecutorService
extends ContextAwareExecutor,
ExecutorService {
    public static ContextAwareExecutorService of(RequestContext context, ExecutorService executor) {
        Objects.requireNonNull(context, "context");
        Objects.requireNonNull(executor, "executor");
        if (executor instanceof ContextAwareExecutorService) {
            RequestContextUtil.ensureSameCtx(context, (ContextAwareExecutorService)executor, ContextAwareExecutorService.class);
            return (ContextAwareExecutorService)executor;
        }
        return new DefaultContextAwareExecutorService(context, executor);
    }

    @Override
    public RequestContext context();

    @Override
    public ExecutorService withoutContext();
}

