/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.ByteBufAccessMode;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.common.util.SafeCloseable;
import io.opentelemetry.testing.internal.io.netty.buffer.ByteBuf;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

@UnstableApi
public interface Bytes
extends SafeCloseable {
    public byte[] array();

    public int length();

    default public boolean isEmpty() {
        return this.length() == 0;
    }

    public String toString(Charset var1);

    default public String toStringUtf8() {
        return this.toString(StandardCharsets.UTF_8);
    }

    default public String toStringAscii() {
        return this.toString(StandardCharsets.US_ASCII);
    }

    public InputStream toInputStream();

    default public Reader toReader(Charset charset) {
        Objects.requireNonNull(charset, "charset");
        return new InputStreamReader(this.toInputStream(), charset);
    }

    default public Reader toReaderUtf8() {
        return this.toReader(StandardCharsets.UTF_8);
    }

    default public Reader toReaderAscii() {
        return this.toReader(StandardCharsets.US_ASCII);
    }

    public boolean isPooled();

    default public ByteBuf byteBuf() {
        return this.byteBuf(ByteBufAccessMode.DUPLICATE);
    }

    public ByteBuf byteBuf(ByteBufAccessMode var1);

    public ByteBuf byteBuf(int var1, int var2, ByteBufAccessMode var3);

    default public void touch(@Nullable Object hint) {
    }

    @Override
    public void close();
}

